/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.minecraft.class_310;

public class CameraUniforms {
    private static final class_310 client = class_310.method_1551();

    private CameraUniforms() {
    }

    public static void addCameraUniforms(UniformHolder uniformHolder, FrameUpdateNotifier frameUpdateNotifier) {
        CameraPositionTracker cameraPositionTracker = new CameraPositionTracker(frameUpdateNotifier);
        uniformHolder.uniform1f(UniformUpdateFrequency.ONCE, "near", () -> 0.05).uniform1f(UniformUpdateFrequency.PER_FRAME, "far", CameraUniforms::getRenderDistanceInBlocks).uniform3d(UniformUpdateFrequency.PER_FRAME, "cameraPosition", cameraPositionTracker::getCurrentCameraPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "eyeAltitude", cameraPositionTracker::getCurrentCameraPositionY).uniform3d(UniformUpdateFrequency.PER_FRAME, "previousCameraPosition", cameraPositionTracker::getPreviousCameraPosition);
    }

    private static int getRenderDistanceInBlocks() {
        return CameraUniforms.client.field_1690.method_38521() * 16;
    }

    public static Vector3d getUnshiftedCameraPosition() {
        return JomlConversions.fromVec3(CameraUniforms.client.field_1773.method_19418().method_19326());
    }

    static class CameraPositionTracker {
        private static final double WALK_RANGE = 30000.0;
        private static final double TP_RANGE = 1000.0;
        private Vector3d previousCameraPosition = new Vector3d();
        private Vector3d currentCameraPosition = new Vector3d();
        private final Vector3d shift = new Vector3d();

        CameraPositionTracker(FrameUpdateNotifier frameUpdateNotifier) {
            frameUpdateNotifier.addListener(this::update);
        }

        private void update() {
            this.previousCameraPosition = this.currentCameraPosition;
            this.currentCameraPosition = CameraUniforms.getUnshiftedCameraPosition().add(this.shift);
            this.updateShift();
        }

        private void updateShift() {
            double d = CameraPositionTracker.getShift(this.currentCameraPosition.x, this.previousCameraPosition.x);
            double d2 = CameraPositionTracker.getShift(this.currentCameraPosition.z, this.previousCameraPosition.z);
            if (d != 0.0 || d2 != 0.0) {
                this.applyShift(d, d2);
            }
        }

        private static double getShift(double d, double d2) {
            if (Math.abs(d) > 30000.0 || Math.abs(d - d2) > 1000.0) {
                return -(d - d % 30000.0);
            }
            return 0.0;
        }

        private void applyShift(double d, double d2) {
            this.shift.x += d;
            this.currentCameraPosition.x += d;
            this.previousCameraPosition.x += d;
            this.shift.z += d2;
            this.currentCameraPosition.z += d2;
            this.previousCameraPosition.z += d2;
        }

        public Vector3d getCurrentCameraPosition() {
            return this.currentCameraPosition;
        }

        public Vector3d getPreviousCameraPosition() {
            return this.previousCameraPosition;
        }

        public double getCurrentCameraPositionY() {
            return this.currentCameraPosition.y;
        }
    }
}

