/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms.custom;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kroppeb.stareval.function.Type;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.custom.cached.BooleanCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.CachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float2VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float3VanillaVectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float3VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float4MatrixCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float4VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.FloatCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Int2VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.IntCachedUniform;
import net.coderbot.iris.vendored.joml.Matrix4f;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector2i;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import org.lwjgl.BufferUtils;

public class CustomUniformFixedInputUniformsHolder {
    private final ImmutableMap<String, CachedUniform> inputVariables;

    public CustomUniformFixedInputUniformsHolder(ImmutableMap<String, CachedUniform> immutableMap) {
        this.inputVariables = immutableMap;
    }

    public Type getType(String string) {
        CachedUniform cachedUniform = (CachedUniform)this.inputVariables.get((Object)string);
        if (cachedUniform == null) {
            return null;
        }
        return cachedUniform.getType();
    }

    public boolean containsKey(String string) {
        return this.inputVariables.containsKey((Object)string);
    }

    public CachedUniform getUniform(String string) {
        return (CachedUniform)this.inputVariables.get((Object)string);
    }

    public void updateAll() {
        for (CachedUniform cachedUniform : this.inputVariables.values()) {
            cachedUniform.update();
        }
    }

    public Collection<CachedUniform> getAll() {
        return this.inputVariables.values();
    }

    public static class Builder
    implements UniformHolder {
        private final Map<String, CachedUniform> inputVariables = new Object2ObjectOpenHashMap();

        private Builder put(String string, CachedUniform cachedUniform) {
            if (this.inputVariables.containsKey(string)) {
                Iris.logger.warn("Duplicated fixed uniform supplied as inputs to the Custom uniform holder: " + string);
                return this;
            }
            this.inputVariables.put(string, cachedUniform);
            return this;
        }

        @Override
        public Builder uniform1f(UniformUpdateFrequency uniformUpdateFrequency, String string, FloatSupplier floatSupplier) {
            return this.put(string, new FloatCachedUniform(string, uniformUpdateFrequency, floatSupplier));
        }

        @Override
        public Builder uniform1f(UniformUpdateFrequency uniformUpdateFrequency, String string, IntSupplier intSupplier) {
            return this.put(string, new FloatCachedUniform(string, uniformUpdateFrequency, intSupplier::getAsInt));
        }

        @Override
        public Builder uniform1f(UniformUpdateFrequency uniformUpdateFrequency, String string, DoubleSupplier doubleSupplier) {
            return this.put(string, new FloatCachedUniform(string, uniformUpdateFrequency, () -> (float)doubleSupplier.getAsDouble()));
        }

        @Override
        public Builder uniform1i(UniformUpdateFrequency uniformUpdateFrequency, String string, IntSupplier intSupplier) {
            return this.put(string, new IntCachedUniform(string, uniformUpdateFrequency, intSupplier));
        }

        @Override
        public Builder uniform1b(UniformUpdateFrequency uniformUpdateFrequency, String string, BooleanSupplier booleanSupplier) {
            return this.put(string, new BooleanCachedUniform(string, uniformUpdateFrequency, booleanSupplier));
        }

        @Override
        public Builder uniform2f(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<Vector2f> supplier) {
            return this.put(string, new Float2VectorCachedUniform(string, uniformUpdateFrequency, supplier));
        }

        @Override
        public Builder uniform2i(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<Vector2i> supplier) {
            return this.put(string, new Int2VectorCachedUniform(string, uniformUpdateFrequency, supplier));
        }

        @Override
        public Builder uniform3f(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<Vector3f> supplier) {
            return this.put(string, new Float3VectorCachedUniform(string, uniformUpdateFrequency, supplier));
        }

        @Override
        public UniformHolder uniformVanilla3f(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<class_1160> supplier) {
            return this.put(string, new Float3VanillaVectorCachedUniform(string, uniformUpdateFrequency, supplier));
        }

        @Override
        public Builder uniformTruncated3f(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<Vector4f> supplier) {
            Vector3f vector3f = new Vector3f();
            return this.put(string, new Float3VectorCachedUniform(string, uniformUpdateFrequency, () -> {
                Vector4f vector4f = (Vector4f)supplier.get();
                vector3f.set(vector4f.x(), vector4f.y(), vector4f.z());
                return vector3f;
            }));
        }

        @Override
        public UniformHolder uniform3d(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<Vector3d> supplier) {
            Vector3f vector3f = new Vector3f();
            return this.put(string, new Float3VectorCachedUniform(string, uniformUpdateFrequency, () -> {
                Vector3d vector3d = (Vector3d)supplier.get();
                vector3f.set(vector3d.x(), vector3d.y(), vector3d.z());
                return vector3f;
            }));
        }

        @Override
        public UniformHolder uniform4f(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<Vector4f> supplier) {
            Vector4f vector4f = new Vector4f();
            return this.put(string, new Float4VectorCachedUniform(string, uniformUpdateFrequency, () -> {
                Vector4f vector4f2 = (Vector4f)supplier.get();
                vector4f.set(vector4f2.x(), vector4f2.y(), vector4f2.z(), vector4f2.w());
                return vector4f;
            }));
        }

        @Override
        public UniformHolder uniform4fArray(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<float[]> supplier) {
            Vector4f vector4f = new Vector4f();
            return this.put(string, new Float4VectorCachedUniform(string, uniformUpdateFrequency, () -> {
                float[] fArray = (float[])supplier.get();
                vector4f.set(fArray);
                return vector4f;
            }));
        }

        @Override
        public UniformHolder uniformMatrix(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<class_1159> supplier) {
            Matrix4f matrix4f = new Matrix4f();
            FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
            return this.put(string, new Float4MatrixCachedUniform(string, uniformUpdateFrequency, () -> {
                ((class_1159)supplier.get()).method_4932(floatBuffer);
                matrix4f.set(floatBuffer);
                return matrix4f;
            }));
        }

        @Override
        public UniformHolder uniformJomlMatrix(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<Matrix4f> supplier) {
            return this.put(string, new Float4MatrixCachedUniform(string, uniformUpdateFrequency, supplier));
        }

        @Override
        public UniformHolder uniformMatrixFromArray(UniformUpdateFrequency uniformUpdateFrequency, String string, Supplier<float[]> supplier) {
            Matrix4f matrix4f = new Matrix4f();
            return this.put(string, new Float4MatrixCachedUniform(string, uniformUpdateFrequency, () -> {
                matrix4f.set((float[])supplier.get());
                return matrix4f;
            }));
        }

        @Override
        public UniformHolder externallyManagedUniform(String string, UniformType uniformType) {
            return this;
        }

        public CustomUniformFixedInputUniformsHolder build() {
            return new CustomUniformFixedInputUniformsHolder((ImmutableMap<String, CachedUniform>)ImmutableMap.copyOf(this.inputVariables));
        }
    }
}

