/*
 * Decompiled with CFR 0.152.
 */
package glm_.quat;

import glm_.ExtensionsKt;
import glm_.glm;
import glm_.gtc.gtc_Quaternion;
import glm_.mat3x3.Mat3;
import glm_.mat3x3.Mat3d;
import glm_.mat4x4.Mat4;
import glm_.mat4x4.Mat4d;
import glm_.quat.QuatD;
import glm_.quat.QuatT;
import glm_.quat.quat_operators;
import glm_.vec3.Vec3;
import glm_.vec3.Vec3d;
import glm_.vec4.Vec4;
import glm_.vec4.Vec4bool;
import glm_.vec4.Vec4t;
import java.io.InputStream;
import java.io.PrintStream;
import kool.PointersKt;
import kool.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0004\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u007f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u007fB\t\b\u0016\u00a2\u0006\u0004\be\u0010fB\u0011\b\u0016\u0012\u0006\u0010g\u001a\u00020\u0002\u00a2\u0006\u0004\be\u0010\u001cB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0004\be\u0010.B\u0019\b\u0016\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020B0\u0001\u00a2\u0006\u0004\be\u0010hB\u0019\b\u0016\u0012\u0006\u0010i\u001a\u00020\u0002\u0012\u0006\u0010j\u001a\u00020\n\u00a2\u0006\u0004\be\u0010kB\u0019\b\u0016\u0012\u0006\u0010l\u001a\u00020\n\u0012\u0006\u0010j\u001a\u00020\n\u00a2\u0006\u0004\be\u0010mB\u001d\b\u0016\u0012\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00020n\u00a2\u0006\u0004\be\u0010pB\u0011\b\u0016\u0012\u0006\u0010q\u001a\u00020\n\u00a2\u0006\u0004\be\u0010QB\u0011\b\u0016\u0012\u0006\u0010r\u001a\u00020M\u00a2\u0006\u0004\be\u0010RB\u001b\b\u0016\u0012\u0006\u0010t\u001a\u00020s\u0012\b\b\u0002\u0010u\u001a\u00020\u0005\u00a2\u0006\u0004\be\u0010vB\u0014\b\u0016\u0012\u0006\u0010Z\u001a\u00020w\u00f8\u0001\u0000\u00a2\u0006\u0004\be\u0010xB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020y\u00a2\u0006\u0004\be\u0010zB)\b\u0016\u0012\u0006\u0010<\u001a\u00020B\u0012\u0006\u0010=\u001a\u00020B\u0012\u0006\u0010>\u001a\u00020B\u0012\u0006\u0010?\u001a\u00020B\u00a2\u0006\u0004\be\u0010{B\u0015\b\u0016\u0012\n\u0010r\u001a\u0006\u0012\u0002\b\u00030|\u00a2\u0006\u0004\be\u0010}B'\u0012\u0006\u0010<\u001a\u00020\u0002\u0012\u0006\u0010=\u001a\u00020\u0002\u0012\u0006\u0010>\u001a\u00020\u0002\u0012\u0006\u0010?\u001a\u00020\u0002\u00a2\u0006\u0004\be\u0010~J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\r\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0007J\u0019\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0002H\u0086\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0019J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0002H\u0086\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010!\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0096\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010#\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0019\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b(\u0010\u0013J\r\u0010)\u001a\u00020\u0000\u00a2\u0006\u0004\b)\u0010\u0015J\r\u0010*\u001a\u00020\u0002\u00a2\u0006\u0004\b*\u0010\tJ\u0018\u0010+\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\b+\u0010\u0013J\u001d\u0010+\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b+\u0010,J\u0018\u0010-\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\b-\u0010.J\u0019\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b/\u0010\u0013J\r\u00100\u001a\u00020\u0000\u00a2\u0006\u0004\b0\u0010\u0015J\u0018\u00101\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\b1\u0010\u0013J\u001d\u00101\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b1\u0010,J\u0018\u00102\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\b2\u0010.J#\u00107\u001a\u00020\u001a2\b\b\u0002\u00104\u001a\u0002032\b\b\u0002\u00106\u001a\u000205H\u0007\u00a2\u0006\u0004\b7\u00108J#\u00109\u001a\u00020\u001a2\b\b\u0002\u00104\u001a\u0002032\b\b\u0002\u00106\u001a\u000205H\u0007\u00a2\u0006\u0004\b9\u00108J\u0018\u0010;\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b;\u0010\u0013J-\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u00022\u0006\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u0002\u00a2\u0006\u0004\b;\u0010@J \u0010D\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020%2\u0006\u0010C\u001a\u00020BH\u0096\u0002\u00a2\u0006\u0004\bD\u0010EJ)\u0010G\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\bG\u0010HJ\u001d\u0010I\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0002\u00a2\u0006\u0004\bI\u0010JJ\u0018\u0010K\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\bK\u0010\u0013J\u001d\u0010K\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\bK\u0010,J\u0018\u0010K\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0086\u0006\u00a2\u0006\u0004\bK\u0010$J\u001d\u0010K\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\bK\u0010LJ\u0018\u0010K\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020MH\u0086\u0006\u00a2\u0006\u0004\bK\u0010NJ\u001d\u0010K\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020M2\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\bK\u0010OJ\u0018\u0010K\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0002H\u0086\u0006\u00a2\u0006\u0004\bK\u0010\u0018J\u001d\u0010K\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\bK\u0010\u0019J\u0018\u0010P\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\bP\u0010.J\u0018\u0010P\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\nH\u0086\u0006\u00a2\u0006\u0004\bP\u0010QJ\u0018\u0010P\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020MH\u0086\u0006\u00a2\u0006\u0004\bP\u0010RJ\u0018\u0010P\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0002H\u0086\u0006\u00a2\u0006\u0004\bP\u0010\u001cJ\u0018\u0010T\u001a\u00020S2\u0006\u0010\f\u001a\u00020SH\u0086\u0004\u00a2\u0006\u0004\bT\u0010UJ\u0018\u0010T\u001a\u00020V2\u0006\u0010\f\u001a\u00020VH\u0086\u0004\u00a2\u0006\u0004\bT\u0010WJ\u001c\u0010T\u001a\u00020\u001a2\n\u0010Z\u001a\u00060Xj\u0002`YH\u0086\u0004\u00a2\u0006\u0004\bT\u0010[J\r\u0010\\\u001a\u00020S\u00a2\u0006\u0004\b\\\u0010]J\r\u0010^\u001a\u00020V\u00a2\u0006\u0004\b^\u0010_J\u000f\u0010`\u001a\u000203H\u0016\u00a2\u0006\u0004\b`\u0010aJ\u0010\u0010b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\bb\u0010\u0015J\u0010\u0010c\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\bc\u0010\u0015J\u0019\u0010d\u001a\u00020\u001a2\b\b\u0002\u0010\f\u001a\u00020MH\u0007\u00a2\u0006\u0004\bd\u0010R\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0080\u0001"}, d2={"Lglm_/quat/Quat;", "Lglm_/quat/QuatT;", "", "q", "epsilon", "", "allEqual", "(Lglm_/quat/Quat;F)Z", "angle", "()F", "Lglm_/vec3/Vec3;", "axis", "res", "angleAxis", "(FLglm_/vec3/Vec3;Lglm_/quat/Quat;)Lglm_/quat/Quat;", "angleAxisAssign", "(FLglm_/vec3/Vec3;)Lglm_/quat/Quat;", "anyNotEqual", "conjugate", "(Lglm_/quat/Quat;)Lglm_/quat/Quat;", "conjugateAssign", "()Lglm_/quat/Quat;", "b", "div", "(F)Lglm_/quat/Quat;", "(FLglm_/quat/Quat;)Lglm_/quat/Quat;", "", "divAssign", "(F)V", "dot", "(Lglm_/quat/Quat;)F", "", "other", "equals", "(Ljava/lang/Object;)Z", "eulerAngles", "(Lglm_/vec3/Vec3;)Lglm_/vec3/Vec3;", "", "hashCode", "()I", "inverse", "inverseAssign", "length", "minus", "(Lglm_/quat/Quat;Lglm_/quat/Quat;)Lglm_/quat/Quat;", "minusAssign", "(Lglm_/quat/Quat;)V", "normalize", "normalizeAssign", "plus", "plusAssign", "", "name", "Ljava/io/PrintStream;", "stream", "print", "(Ljava/lang/String;Ljava/io/PrintStream;)V", "println", "quat", "put", "w", "x", "y", "z", "(FFFF)Lglm_/quat/Quat;", "index", "", "value", "set", "(ILjava/lang/Number;)V", "interp", "slerp", "(Lglm_/quat/Quat;FLglm_/quat/Quat;)Lglm_/quat/Quat;", "slerpAssign", "(Lglm_/quat/Quat;F)Lglm_/quat/Quat;", "times", "(Lglm_/vec3/Vec3;Lglm_/vec3/Vec3;)Lglm_/vec3/Vec3;", "Lglm_/vec4/Vec4;", "(Lglm_/vec4/Vec4;)Lglm_/quat/Quat;", "(Lglm_/vec4/Vec4;Lglm_/quat/Quat;)Lglm_/quat/Quat;", "timesAssign", "(Lglm_/vec3/Vec3;)V", "(Lglm_/vec4/Vec4;)V", "Lglm_/mat3x3/Mat3;", "to", "(Lglm_/mat3x3/Mat3;)Lglm_/mat3x3/Mat3;", "Lglm_/mat4x4/Mat4;", "(Lglm_/mat4x4/Mat4;)Lglm_/mat4x4/Mat4;", "", "Lkool/Ptr;", "ptr", "(J)V", "toMat3", "()Lglm_/mat3x3/Mat3;", "toMat4", "()Lglm_/mat4x4/Mat4;", "toString", "()Ljava/lang/String;", "unaryMinus", "unaryPlus", "vectorize", "<init>", "()V", "f", "(Lglm_/quat/QuatT;)V", "s", "v", "(FLglm_/vec3/Vec3;)V", "u", "(Lglm_/vec3/Vec3;Lglm_/vec3/Vec3;)V", "Lkotlin/Function1;", "block", "(Lkotlin/jvm/functions/Function1;)V", "eulerAngle", "vec4", "Ljava/io/InputStream;", "inputStream", "bigEndian", "(Ljava/io/InputStream;Z)V", "Lkool/FloatPtr;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Lglm_/quat/QuatD;", "(Lglm_/quat/QuatD;)V", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lglm_/vec4/Vec4t;", "(Lglm_/vec4/Vec4t;)V", "(FFFF)V", "Companion", "glm-jdk8"})
public final class Quat
extends QuatT<Float> {
    @JvmField
    public static final int length;
    @JvmField
    public static final int size;
    public static final Companion Companion;

    @NotNull
    public final Mat3 to(@NotNull Mat3 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.mat3_cast(this, res2);
    }

    @NotNull
    public final Mat3 toMat3() {
        return glm.INSTANCE.mat3_cast(this, new Mat3());
    }

    @NotNull
    public final Mat4 to(@NotNull Mat4 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.mat4_cast(this, res2);
    }

    @NotNull
    public final Mat4 toMat4() {
        return glm.INSTANCE.mat4_cast(this, new Mat4());
    }

    @NotNull
    public final Quat put(float w, float x, float y, float z) {
        this.w = Float.valueOf(w);
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.z = Float.valueOf(z);
        return this;
    }

    @NotNull
    public final Quat put(@NotNull Quat quat) {
        Intrinsics.checkNotNullParameter((Object)quat, (String)"quat");
        return this.put(quat.w.floatValue(), quat.x.floatValue(), quat.y.floatValue(), quat.z.floatValue());
    }

    public final void to(long ptr) {
        MemoryUtil.memPutFloat((long)ptr, (float)this.w.floatValue());
        MemoryUtil.memPutFloat((long)(ptr + (long)UtilsKt.getBYTES(FloatCompanionObject.INSTANCE)), (float)this.x.floatValue());
        MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2)), (float)this.y.floatValue());
        MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3)), (float)this.z.floatValue());
    }

    @Override
    public void set(int index, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (index) {
            case 0: {
                this.x = Float.valueOf(ExtensionsKt.getF(value));
                break;
            }
            case 1: {
                this.y = Float.valueOf(ExtensionsKt.getF(value));
                break;
            }
            case 2: {
                this.z = Float.valueOf(ExtensionsKt.getF(value));
                break;
            }
            case 3: {
                this.w = Float.valueOf(ExtensionsKt.getF(value));
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final Quat unaryPlus() {
        return this;
    }

    @NotNull
    public final Quat unaryMinus() {
        return new Quat(-this.w.floatValue(), -this.x.floatValue(), -this.y.floatValue(), -this.z.floatValue());
    }

    @NotNull
    public final Quat plus(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.plus(new Quat(), this, b);
    }

    @NotNull
    public final Quat plus(@NotNull Quat b, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.plus(res2, this, b);
    }

    public final void plusAssign(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.plus(this, this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.minus(new Quat(), this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.minus(res2, this, b);
    }

    public final void minusAssign(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.minus(this, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(float b) {
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Vec3(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final Quat times(float b, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b, @NotNull Vec3 res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    public final void timesAssign(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(this, this, b);
    }

    public final void timesAssign(float b) {
        Companion.times(this, this, b);
    }

    public final void timesAssign(@NotNull Vec3 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(b, this, b);
    }

    public final void timesAssign(@NotNull Vec4 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(this, this, b);
    }

    @NotNull
    public final Quat div(float b) {
        return Companion.div(new Quat(), this, b);
    }

    @NotNull
    public final Quat div(float b, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.div(res2, this, b);
    }

    public final void divAssign(float b) {
        Companion.div(this, this, b);
    }

    public final float length() {
        return glm.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize(@NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.normalize(this, res2);
    }

    public static /* synthetic */ Quat normalize$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.normalize(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize() {
        return Quat.normalize$default(this, null, 1, null);
    }

    @NotNull
    public final Quat normalizeAssign() {
        return glm.INSTANCE.normalize(this, this);
    }

    public final float dot(@NotNull Quat b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return glm.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.angleAxis(angle, axis, res2);
    }

    public static /* synthetic */ Quat angleAxis$default(Quat quat, float f2, Vec3 vec3, Quat quat2, int n, Object object) {
        if ((n & 4) != 0) {
            quat2 = new Quat();
        }
        return quat.angleAxis(f2, vec3, quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis) {
        return Quat.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @NotNull
    public final Quat angleAxisAssign(float angle, @NotNull Vec3 axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return glm.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate(@NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.conjugate(this, res2);
    }

    public static /* synthetic */ Quat conjugate$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.conjugate(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate() {
        return Quat.conjugate$default(this, null, 1, null);
    }

    @NotNull
    public final Quat conjugateAssign() {
        return glm.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse(@NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.inverse(this, res2);
    }

    public static /* synthetic */ Quat inverse$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.inverse(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse() {
        return Quat.inverse$default(this, null, 1, null);
    }

    @NotNull
    public final Quat inverseAssign() {
        return glm.INSTANCE.inverse(this, this);
    }

    public final float angle() {
        return glm.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles(@NotNull Vec3 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.eulerAngles(this, res2);
    }

    public static /* synthetic */ Vec3 eulerAngles$default(Quat quat, Vec3 vec3, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = new Vec3();
        }
        return quat.eulerAngles(vec3);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles() {
        return Quat.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp, @NotNull Quat res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.slerp(this, b, interp, res2);
    }

    public static /* synthetic */ Quat slerp$default(Quat quat, Quat quat2, float f2, Quat quat3, int n, Object object) {
        if ((n & 4) != 0) {
            quat3 = new Quat();
        }
        return quat.slerp(quat2, f2, quat3);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp) {
        return Quat.slerp$default(this, b, interp, null, 4, null);
    }

    @NotNull
    public final Quat slerpAssign(@NotNull Quat b, float interp) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return glm.INSTANCE.slerp(this, b, interp, this);
    }

    @JvmOverloads
    public final void vectorize(@NotNull Vec4 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        res2.put(this.x.floatValue(), this.y.floatValue(), this.z.floatValue(), this.w.floatValue());
    }

    public static /* synthetic */ void vectorize$default(Quat quat, Vec4 vec42, int n, Object object) {
        if ((n & 1) != 0) {
            vec42 = new Vec4();
        }
        quat.vectorize(vec42);
    }

    @JvmOverloads
    public final void vectorize() {
        Quat.vectorize$default(this, null, 1, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Quat && ((Number)this.get(0)).floatValue() == ((Number)((Quat)other).get(0)).floatValue() && ((Number)this.get(1)).floatValue() == ((Number)((Quat)other).get(1)).floatValue() && ((Number)this.get(2)).floatValue() == ((Number)((Quat)other).get(2)).floatValue() && ((Number)this.get(3)).floatValue() == ((Number)((Quat)other).get(3)).floatValue();
    }

    public int hashCode() {
        return 31 * (31 * (31 * Float.hashCode(this.w.floatValue()) + Float.hashCode(this.x.floatValue())) + Float.hashCode(this.y.floatValue())) + Float.hashCode(this.z.floatValue());
    }

    @JvmOverloads
    public final void print(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.print(name + this);
    }

    public static /* synthetic */ void print$default(Quat quat, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        quat.print(string, printStream);
    }

    @JvmOverloads
    public final void print(@NotNull String name) {
        Quat.print$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void print() {
        Quat.print$default(this, null, null, 3, null);
    }

    @JvmOverloads
    public final void println(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.println(name + this);
    }

    public static /* synthetic */ void println$default(Quat quat, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        quat.println(string, printStream);
    }

    @JvmOverloads
    public final void println(@NotNull String name) {
        Quat.println$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void println() {
        Quat.println$default(this, null, null, 3, null);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.w.floatValue() + ", {" + this.x.floatValue() + ", " + this.y.floatValue() + ", " + this.z.floatValue() + "})";
    }

    public final boolean allEqual(@NotNull Quat q, float epsilon2) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.floatValue() - q.x.floatValue() < epsilon2 && this.y.floatValue() - q.y.floatValue() < epsilon2 && this.z.floatValue() - q.z.floatValue() < epsilon2 && this.w.floatValue() - q.w.floatValue() < epsilon2;
    }

    public static /* synthetic */ boolean allEqual$default(Quat quat, Quat quat2, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = glm.INSTANCE.get\u03b5f();
        }
        return quat.allEqual(quat2, f2);
    }

    public final boolean anyNotEqual(@NotNull Quat q, float epsilon2) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.floatValue() - q.x.floatValue() >= epsilon2 || this.y.floatValue() - q.y.floatValue() >= epsilon2 || this.z.floatValue() - q.z.floatValue() >= epsilon2 || this.w.floatValue() - q.w.floatValue() >= epsilon2;
    }

    public static /* synthetic */ boolean anyNotEqual$default(Quat quat, Quat quat2, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = glm.INSTANCE.get\u03b5f();
        }
        return quat.anyNotEqual(quat2, f2);
    }

    public Quat(float w, float x, float y, float z) {
        super((Number)Float.valueOf(w), (Number)Float.valueOf(x), (Number)Float.valueOf(y), (Number)Float.valueOf(z));
    }

    public Quat() {
        this(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public Quat(float f2) {
        this(f2, f2, f2, f2);
    }

    public Quat(@NotNull Quat q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this(q.w.floatValue(), q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
    }

    public Quat(@NotNull QuatT<? extends Number> q) {
        Intrinsics.checkNotNullParameter(q, (String)"q");
        this((Number)q.w, (Number)q.x, (Number)q.y, (Number)q.z);
    }

    public Quat(float s, @NotNull Vec3 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this(s, v2.getX().floatValue(), v2.getY().floatValue(), v2.getZ().floatValue());
    }

    public Quat(@NotNull Vec3 u, @NotNull Vec3 v2) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this();
        float f2 = u.dot(u) * v2.dot(v2);
        boolean bl = false;
        float normUnormV = (float)Math.sqrt(f2);
        float realPart = normUnormV + u.dot(v2);
        if (realPart < 1.0E-6f * normUnormV) {
            realPart = 0.0f;
            float f3 = u.getX().floatValue();
            boolean bl2 = false;
            float f4 = Math.abs(f3);
            f3 = u.getZ().floatValue();
            bl2 = false;
            vec3 = f4 > Math.abs(f3) ? new Vec3(-u.getY().floatValue(), u.getX().floatValue(), 0.0f) : new Vec3(0.0f, -u.getZ().floatValue(), u.getY().floatValue());
        } else {
            vec3 = u.cross(v2);
        }
        Vec3 w = vec3;
        this.put(realPart, w.getX().floatValue(), w.getY().floatValue(), w.getZ().floatValue()).normalizeAssign();
    }

    public Quat(@NotNull Function1<? super Integer, Float> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(((Number)block.invoke((Object)0)).floatValue(), ((Number)block.invoke((Object)1)).floatValue(), ((Number)block.invoke((Object)2)).floatValue(), ((Number)block.invoke((Object)3)).floatValue());
    }

    public Quat(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkNotNullParameter((Object)eulerAngle, (String)"eulerAngle");
        this();
        float eX = eulerAngle.getX().floatValue() * 0.5f;
        float eY = eulerAngle.getY().floatValue() * 0.5f;
        float eZ = eulerAngle.getZ().floatValue() * 0.5f;
        float cX = glm.INSTANCE.cos(eX);
        float cY = glm.INSTANCE.cos(eY);
        float cZ = glm.INSTANCE.cos(eZ);
        float sX = glm.INSTANCE.sin(eX);
        float sY = glm.INSTANCE.sin(eY);
        float sZ = glm.INSTANCE.sin(eZ);
        this.w = Float.valueOf(cX * cY * cZ + sX * sY * sZ);
        this.x = Float.valueOf(sX * cY * cZ - cX * sY * sZ);
        this.y = Float.valueOf(cX * sY * cZ + sX * cY * sZ);
        this.z = Float.valueOf(cX * cY * sZ - sX * sY * cZ);
    }

    public Quat(@NotNull Vec4 vec42) {
        Intrinsics.checkNotNullParameter((Object)vec42, (String)"vec4");
        this(vec42.getW().floatValue(), vec42.getX().floatValue(), vec42.getY().floatValue(), vec42.getZ().floatValue());
    }

    public Quat(@NotNull InputStream inputStream, boolean bigEndian) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian));
    }

    public /* synthetic */ Quat(InputStream inputStream, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(inputStream, bl);
    }

    private Quat(final long ptr) {
        this((Function1<? super Integer, Float>)((Function1)new Function1<Integer, Float>(){

            public final float invoke(int i2) {
                long $this$iv = ptr;
                boolean $i$f$get = false;
                return PointersKt.getUNSAFE().getFloat(null, $this$iv + (long)(i2 * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE)));
            }
        }));
    }

    public Quat(@NotNull QuatD q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this(ExtensionsKt.getF(q.w), ExtensionsKt.getF(q.x), ExtensionsKt.getF(q.y), ExtensionsKt.getF(q.z));
    }

    public Quat(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        this(ExtensionsKt.getF(w), ExtensionsKt.getF(x), ExtensionsKt.getF(y), ExtensionsKt.getF(z));
    }

    public Quat(@NotNull Vec4t<?> vec42) {
        Intrinsics.checkNotNullParameter(vec42, (String)"vec4");
        this(ExtensionsKt.getF(vec42.getW()), ExtensionsKt.getF(vec42.getX()), ExtensionsKt.getF(vec42.getY()), ExtensionsKt.getF(vec42.getZ()));
    }

    static {
        Companion = new Companion(null);
        length = 4;
        size = length * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE);
    }

    public /* synthetic */ Quat(long ptr, DefaultConstructorMarker $constructor_marker) {
        this(ptr);
    }

    @JvmStatic
    @NotNull
    public static final Quat fromPointer(long ptr) {
        return Companion.fromPointer(ptr);
    }

    @Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lglm_/quat/Quat$Companion;", "Lglm_/quat/quat_operators;", "Lglm_/gtc/gtc_Quaternion;", "", "Lkool/Ptr;", "ptr", "Lglm_/quat/Quat;", "fromPointer", "(J)Lglm_/quat/Quat;", "getIdentity", "()Lglm_/quat/Quat;", "identity", "", "length", "I", "size", "<init>", "()V", "glm-jdk8"})
    public static final class Companion
    implements quat_operators,
    gtc_Quaternion {
        @JvmStatic
        @NotNull
        public final Quat fromPointer(long ptr) {
            return new Quat(MemoryUtil.memGetFloat((long)ptr), MemoryUtil.memGetFloat((long)(ptr + (long)UtilsKt.getBYTES(FloatCompanionObject.INSTANCE))), MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2))), MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3))));
        }

        @NotNull
        public final Quat getIdentity() {
            return new Quat(1.0f, 0.0f, 0.0f, 0.0f);
        }

        private Companion() {
        }

        @Override
        @NotNull
        public Quat plus(@NotNull Quat res2, @NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quat_operators.DefaultImpls.plus(this, res2, a, b);
        }

        @Override
        @NotNull
        public Quat minus(@NotNull Quat res2, @NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quat_operators.DefaultImpls.minus(this, res2, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res2, @NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res2, @NotNull Quat a, float b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return quat_operators.DefaultImpls.times((quat_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res2, @NotNull Quat a, @NotNull Vec3 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res2, @NotNull Vec3 a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res2, @NotNull Quat a, @NotNull Vec4 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Quat div(@NotNull Quat res2, @NotNull Quat a, float b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return quat_operators.DefaultImpls.div(this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q, res2);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q, res2);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res2, @NotNull QuatD q) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.mat4d_cast(this, res2, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res2) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res2);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res2) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res2);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.greater(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.greater(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.equal(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.equal(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.isNan(this, q, res2);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.isInf(this, q, res2);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.isInf(this, q);
        }

        @Override
        @NotNull
        public Quat quatLookAt(@NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAt(@NotNull Vec3d direction, @NotNull Vec3d up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtRH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtRH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtLH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtLH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

