/*
 * Decompiled with CFR 0.152.
 */
package uno.glm;

import glm_.func.Func_trigonometricKt;
import glm_.glm;
import glm_.mat4x4.Mat4;
import glm_.vec2.Vec2i;
import glm_.vec3.Vec3;
import glm_.vec4.Vec4;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010C\u001a\u00020\b\u00a2\u0006\u0004\bV\u0010PJ,\u0010\u0006\u001a\u00020\u00002\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\b\u0004H\u0086\f\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0086\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0011JC\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001d\u0010\u001eJ)\u0010$\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\b\b\u0002\u0010#\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u0000\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\u0000\u00a2\u0006\u0004\b(\u0010'J\r\u0010)\u001a\u00020\u0000\u00a2\u0006\u0004\b)\u0010'J\u001d\u0010,\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0012\u00a2\u0006\u0004\b,\u0010-J-\u0010,\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012\u00a2\u0006\u0004\b,\u0010\u001eJ\u001d\u00102\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0012\u00a2\u0006\u0004\b2\u0010-J\u0018\u00103\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0012H\u0086\u0004\u00a2\u0006\u0004\b3\u00104J\u0018\u00105\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0012H\u0086\u0004\u00a2\u0006\u0004\b5\u00104J\u0018\u00106\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0012H\u0086\u0004\u00a2\u0006\u0004\b6\u00104J2\u00108\u001a\u00028\u0000\"\u0004\b\u0000\u001072\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\b\u0004H\u0086\f\u00f8\u0001\u0000\u00a2\u0006\u0004\b8\u00109J\u0018\u0010:\u001a\u00020\f2\u0006\u0010:\u001a\u00020\fH\u0086\u0004\u00a2\u0006\u0004\b:\u0010;J\u0018\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020<H\u0086\u0004\u00a2\u0006\u0004\b:\u0010=J\u0018\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0012H\u0086\u0004\u00a2\u0006\u0004\b:\u00104J%\u0010:\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\u0012\u00a2\u0006\u0004\b:\u0010AJ\r\u0010B\u001a\u00020\u0000\u00a2\u0006\u0004\bB\u0010'J\u0018\u0010D\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\bH\u0086\u0004\u00a2\u0006\u0004\bD\u0010\u000bJ\r\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010EJ\u0018\u0010G\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\fH\u0086\u0004\u00a2\u0006\u0004\bG\u0010HJ\u0018\u0010G\u001a\u00020\u00002\u0006\u0010F\u001a\u00020<H\u0086\u0004\u00a2\u0006\u0004\bG\u0010=J\u0018\u0010G\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0012H\u0086\u0004\u00a2\u0006\u0004\bG\u00104J%\u0010G\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\u00122\u0006\u0010K\u001a\u00020\u0012\u00a2\u0006\u0004\bG\u0010AR\"\u0010L\u001a\u00020\b8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010E\"\u0004\bO\u0010PR \u0010R\u001a\b\u0012\u0004\u0012\u00020\b0Q8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010U\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006W"}, d2={"Luno/glm/MatrixStack;", "", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "apply", "(Lkotlin/jvm/functions/Function1;)Luno/glm/MatrixStack;", "Lglm_/mat4x4/Mat4;", "theMatrix", "applyMatrix", "(Lglm_/mat4x4/Mat4;)Luno/glm/MatrixStack;", "Lglm_/vec3/Vec3;", "cameraPos", "lookatPos", "upDir", "lookAt", "(Lglm_/vec3/Vec3;Lglm_/vec3/Vec3;Lglm_/vec3/Vec3;)Luno/glm/MatrixStack;", "", "left", "right", "bottom", "top", "zNear", "zFar", "orthographic", "(FFFFFF)Luno/glm/MatrixStack;", "degFOV", "aspectRatio", "perspective", "(FFFF)Luno/glm/MatrixStack;", "Lglm_/vec2/Vec2i;", "size", "depthRange", "", "isTopLeft", "pixelPerfectOrtho", "(Lglm_/vec2/Vec2i;Lglm_/vec2/Vec2i;Z)Luno/glm/MatrixStack;", "pop", "()Luno/glm/MatrixStack;", "push", "reset", "axis", "angDegCCW", "rotate", "(Lglm_/vec3/Vec3;F)Luno/glm/MatrixStack;", "axisX", "axisY", "axisZ", "angRadCCW", "rotateRadians", "rotateX", "(F)Luno/glm/MatrixStack;", "rotateY", "rotateZ", "R", "run", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "scale", "(Lglm_/vec3/Vec3;)Lglm_/vec3/Vec3;", "Lglm_/vec4/Vec4;", "(Lglm_/vec4/Vec4;)Luno/glm/MatrixStack;", "scaleX", "scaleY", "scaleZ", "(FFF)Luno/glm/MatrixStack;", "setIdentity", "mat", "setMatrix", "()Lglm_/mat4x4/Mat4;", "offset", "translate", "(Lglm_/vec3/Vec3;)Luno/glm/MatrixStack;", "x", "y", "z", "currMat", "Lglm_/mat4x4/Mat4;", "getCurrMat$core", "setCurrMat$core", "(Lglm_/mat4x4/Mat4;)V", "Ljava/util/Stack;", "matrices", "Ljava/util/Stack;", "getMatrices$core", "()Ljava/util/Stack;", "<init>", "core"})
public final class MatrixStack {
    @NotNull
    private final Stack<Mat4> matrices;
    @NotNull
    private Mat4 currMat;

    @NotNull
    public final Stack<Mat4> getMatrices$core() {
        return this.matrices;
    }

    @NotNull
    public final Mat4 getCurrMat$core() {
        return this.currMat;
    }

    public final void setCurrMat$core(@NotNull Mat4 mat4) {
        Intrinsics.checkNotNullParameter((Object)mat4, (String)"<set-?>");
        this.currMat = mat4;
    }

    @NotNull
    public final MatrixStack push() {
        this.matrices.push(new Mat4(this.currMat));
        return this;
    }

    @NotNull
    public final MatrixStack pop() {
        Mat4 mat4 = this.matrices.pop();
        Intrinsics.checkNotNullExpressionValue((Object)mat4, (String)"matrices.pop()");
        this.currMat = mat4;
        return this;
    }

    @NotNull
    public final MatrixStack reset() {
        if (this.matrices.size() != 1) {
            Mat4 mat4 = (Mat4)CollectionsKt.last((List)this.matrices);
            Object e = this.matrices.get(CollectionsKt.getLastIndex((List)this.matrices) - 1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"matrices[matrices.lastIndex - 1]");
            mat4.put((Mat4)e);
            Object object = CollectionsKt.last((List)this.matrices);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"matrices.last()");
            this.currMat = (Mat4)object;
        }
        return this;
    }

    @NotNull
    public final Mat4 top() {
        return this.currMat;
    }

    @NotNull
    public final MatrixStack rotate(@NotNull Vec3 axis, float angDegCCW) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return this.rotate(axis.getX().floatValue(), axis.getY().floatValue(), axis.getZ().floatValue(), angDegCCW);
    }

    @NotNull
    public final MatrixStack rotate(float axisX, float axisY, float axisZ, float angDegCCW) {
        this.currMat.rotateAssign(Func_trigonometricKt.getRad(angDegCCW), axisX, axisY, axisZ);
        return this;
    }

    @NotNull
    public final MatrixStack rotateRadians(@NotNull Vec3 axis, float angRadCCW) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        float cos = glm.INSTANCE.cos(angRadCCW);
        float invCos = 1.0f - cos;
        float sin = glm.INSTANCE.sin(angRadCCW);
        float invSin = 1.0f - sin;
        float dot = axis.getX().floatValue() * axis.getX().floatValue() + axis.getY().floatValue() * axis.getY().floatValue() + axis.getZ().floatValue() * axis.getZ().floatValue();
        float inv = glm.INSTANCE.inverseSqrt(dot);
        float x = axis.getX().floatValue() * inv;
        float y = axis.getY().floatValue() * inv;
        float z = axis.getZ().floatValue() * inv;
        Mat4 theMat = new Mat4(Float.valueOf(1.0f));
        theMat.get(0).setX(axis.getX().floatValue() * axis.getX().floatValue() + (1.0f - axis.getX().floatValue() * axis.getX().floatValue()) * cos);
        theMat.get(1).setX(axis.getX().floatValue() * axis.getY().floatValue() * invCos - axis.getZ().floatValue() * sin);
        theMat.get(2).setX(axis.getX().floatValue() * axis.getZ().floatValue() * invCos + axis.getY().floatValue() * sin);
        theMat.get(0).setY(axis.getX().floatValue() * axis.getY().floatValue() * invCos + axis.getZ().floatValue() * sin);
        theMat.get(1).setY(axis.getY().floatValue() * axis.getY().floatValue() + (1.0f - axis.getY().floatValue() * axis.getY().floatValue()) * cos);
        theMat.get(2).setY(axis.getY().floatValue() * axis.getZ().floatValue() * invCos - axis.getX().floatValue() * sin);
        theMat.get(0).setZ(axis.getX().floatValue() * axis.getZ().floatValue() * invCos - axis.getY().floatValue() * sin);
        theMat.get(1).setZ(axis.getY().floatValue() * axis.getZ().floatValue() * invCos + axis.getX().floatValue() * sin);
        theMat.get(2).setZ(axis.getZ().floatValue() * axis.getZ().floatValue() + (1.0f - axis.getZ().floatValue() * axis.getZ().floatValue()) * cos);
        this.currMat.timesAssign(theMat);
        return this;
    }

    @NotNull
    public final MatrixStack rotateX(float angDegCCW) {
        return this.rotate(1.0f, 0.0f, 0.0f, angDegCCW);
    }

    @NotNull
    public final MatrixStack rotateY(float angDegCCW) {
        return this.rotate(0.0f, 1.0f, 0.0f, angDegCCW);
    }

    @NotNull
    public final MatrixStack rotateZ(float angDegCCW) {
        return this.rotate(0.0f, 0.0f, 1.0f, angDegCCW);
    }

    @NotNull
    public final MatrixStack scale(@NotNull Vec4 scale) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return this.scale(scale.getX().floatValue(), scale.getY().floatValue(), scale.getZ().floatValue());
    }

    @NotNull
    public final Vec3 scale(@NotNull Vec3 scale) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return scale.invoke(scale.getX().floatValue(), scale.getY().floatValue(), scale.getZ().floatValue());
    }

    @NotNull
    public final MatrixStack scale(float scaleX, float scaleY, float scaleZ) {
        this.currMat.scaleAssign(scaleX, scaleY, scaleZ);
        return this;
    }

    @NotNull
    public final MatrixStack scale(float scale) {
        return this.scale(scale, scale, scale);
    }

    @NotNull
    public final MatrixStack translate(@NotNull Vec4 offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return this.translate(offset.getX().floatValue(), offset.getY().floatValue(), offset.getZ().floatValue());
    }

    @NotNull
    public final MatrixStack translate(@NotNull Vec3 offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return this.translate(offset.getX().floatValue(), offset.getY().floatValue(), offset.getZ().floatValue());
    }

    @NotNull
    public final MatrixStack translate(float offset) {
        return this.translate(offset, offset, offset);
    }

    @NotNull
    public final MatrixStack translate(float x, float y, float z) {
        this.currMat.translateAssign(x, y, z);
        return this;
    }

    @NotNull
    public final MatrixStack lookAt(@NotNull Vec3 cameraPos, @NotNull Vec3 lookatPos, @NotNull Vec3 upDir) {
        Intrinsics.checkNotNullParameter((Object)cameraPos, (String)"cameraPos");
        Intrinsics.checkNotNullParameter((Object)lookatPos, (String)"lookatPos");
        Intrinsics.checkNotNullParameter((Object)upDir, (String)"upDir");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final MatrixStack perspective(float degFOV, float aspectRatio, float zNear, float zFar) {
        this.currMat.timesAssign(glm.INSTANCE.perspective(glm.INSTANCE.radians(degFOV), aspectRatio, zNear, zFar));
        return this;
    }

    @JvmOverloads
    @NotNull
    public final MatrixStack orthographic(float left, float right, float bottom, float top, float zNear, float zFar) {
        this.currMat.timesAssign(glm.INSTANCE.ortho(left, right, bottom, top, zNear, zFar));
        return this;
    }

    public static /* synthetic */ MatrixStack orthographic$default(MatrixStack matrixStack, float f2, float f3, float f4, float f5, float f6, float f7, int n, Object object) {
        if ((n & 0x10) != 0) {
            f6 = -1.0f;
        }
        if ((n & 0x20) != 0) {
            f7 = 1.0f;
        }
        return matrixStack.orthographic(f2, f3, f4, f5, f6, f7);
    }

    @JvmOverloads
    @NotNull
    public final MatrixStack orthographic(float left, float right, float bottom, float top, float zNear) {
        return MatrixStack.orthographic$default(this, left, right, bottom, top, zNear, 0.0f, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final MatrixStack orthographic(float left, float right, float bottom, float top) {
        return MatrixStack.orthographic$default(this, left, right, bottom, top, 0.0f, 0.0f, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final MatrixStack pixelPerfectOrtho(@NotNull Vec2i size2, @NotNull Vec2i depthRange, boolean isTopLeft) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        Intrinsics.checkNotNullParameter((Object)depthRange, (String)"depthRange");
        return isTopLeft ? this.translate(-1.0f, 1.0f, (float)(depthRange.getX() + depthRange.getY()) / 2.0f).scale(2.0f / (float)size2.getX().intValue(), -2.0f / (float)size2.getY().intValue(), 1.0f) : this.translate(-1.0f, -1.0f, (float)(depthRange.getX() + depthRange.getY()) / 2.0f).scale(2.0f / (float)size2.getX().intValue(), 2.0f / (float)size2.getY().intValue(), 2.0f / (float)(depthRange.getY() - depthRange.getX()));
    }

    public static /* synthetic */ MatrixStack pixelPerfectOrtho$default(MatrixStack matrixStack, Vec2i vec2i, Vec2i vec2i2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return matrixStack.pixelPerfectOrtho(vec2i, vec2i2, bl);
    }

    @JvmOverloads
    @NotNull
    public final MatrixStack pixelPerfectOrtho(@NotNull Vec2i size2, @NotNull Vec2i depthRange) {
        return MatrixStack.pixelPerfectOrtho$default(this, size2, depthRange, false, 4, null);
    }

    @NotNull
    public final MatrixStack applyMatrix(@NotNull Mat4 theMatrix) {
        Intrinsics.checkNotNullParameter((Object)theMatrix, (String)"theMatrix");
        this.currMat.timesAssign(theMatrix);
        return this;
    }

    @NotNull
    public final MatrixStack setMatrix(@NotNull Mat4 mat) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        this.currMat.put(mat);
        return this;
    }

    @NotNull
    public final MatrixStack setIdentity() {
        this.currMat.put(1.0f);
        return this;
    }

    @NotNull
    public final MatrixStack apply(@NotNull Function1<? super MatrixStack, Unit> block) {
        int $i$f$apply = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.push();
        block.invoke((Object)this);
        this.pop();
        return this;
    }

    public final <R> R run(@NotNull Function1<? super MatrixStack, ? extends R> block) {
        int $i$f$run = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.push();
        Object result2 = block.invoke((Object)this);
        this.pop();
        return (R)result2;
    }

    public MatrixStack(@NotNull Mat4 mat) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        this.matrices = new Stack();
        this.currMat = mat;
    }

    public /* synthetic */ MatrixStack(Mat4 mat4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mat4 = new Mat4();
        }
        this(mat4);
    }

    public MatrixStack() {
        this(null, 1, null);
    }
}

