/*
 * Decompiled with CFR 0.152.
 */
package uno.time;

import glm_.glm;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import uno.time.Timer$WhenMappings;

@Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001.B\u0011\b\u0016\u0012\u0006\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\u0004\b,\u0010\u0006B\u0017\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u0006J\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\rR\u0016\u0010\u000f\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u0016\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0017\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0016\u0010\u001d\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0010R\u0017\u0010\u001e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0010\u001a\u0004\b\u001f\u0010\u0012R\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0011\u0010$\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0012R\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006/"}, d2={"Luno/time/Timer;", "", "", "secFF", "", "fastForward", "(F)V", "reset", "()V", "secRewind", "rewind", "", "togglePause", "()Z", "update", "absPrevTime", "F", "getAlpha", "()F", "alpha", "getDuration", "duration", "hasUpdated", "Z", "isPaused", "setPaused", "(Z)V", "getProgression", "progression", "secAccumTime", "secDuration", "getSecDuration", "", "start", "J", "getTimeSinceStart", "timeSinceStart", "Luno/time/Timer$Type;", "type", "Luno/time/Timer$Type;", "getType", "()Luno/time/Timer$Type;", "setType", "(Luno/time/Timer$Type;)V", "<init>", "(Luno/time/Timer$Type;F)V", "Type", "core"})
public final class Timer {
    private boolean hasUpdated;
    private boolean isPaused;
    private float absPrevTime;
    private float secAccumTime;
    private final long start;
    @NotNull
    private Type type;
    private final float secDuration;

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final void setPaused(boolean bl) {
        this.isPaused = bl;
    }

    public final void reset() {
        this.hasUpdated = false;
        this.secAccumTime = 0.0f;
    }

    public final boolean togglePause() {
        this.isPaused = !this.isPaused;
        return this.isPaused;
    }

    public final boolean update() {
        float absCurrTime = (float)(System.currentTimeMillis() - this.start) / 1000.0f;
        if (!this.hasUpdated) {
            this.absPrevTime = absCurrTime;
            this.hasUpdated = true;
        }
        if (this.isPaused) {
            this.absPrevTime = absCurrTime;
            return false;
        }
        float deltaTime = absCurrTime - this.absPrevTime;
        this.secAccumTime += deltaTime;
        this.absPrevTime = absCurrTime;
        if (this.type == Type.Single) {
            return this.secAccumTime > this.secDuration;
        }
        return false;
    }

    public final void rewind(float secRewind) {
        this.secAccumTime -= secRewind;
        if (this.secAccumTime < 0.0f) {
            this.secAccumTime = 0.0f;
        }
    }

    public final void fastForward(float secFF) {
        this.secAccumTime += secFF;
    }

    public final float getAlpha() {
        float f2;
        switch (Timer$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                f2 = glm.INSTANCE.mod(this.secAccumTime, this.secDuration) / this.secDuration;
                break;
            }
            case 2: {
                f2 = glm.INSTANCE.clamp(this.secAccumTime / this.secDuration, 0.0f, 1.0f);
                break;
            }
            default: {
                f2 = -1.0f;
            }
        }
        return f2;
    }

    public final float getProgression() {
        float f2;
        switch (Timer$WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
            case 1: {
                f2 = glm.INSTANCE.mod(this.secAccumTime, this.secDuration);
                break;
            }
            case 2: {
                f2 = glm.INSTANCE.clamp(this.secAccumTime, 0.0f, this.secDuration);
                break;
            }
            default: {
                f2 = -1.0f;
            }
        }
        return f2;
    }

    public final float getTimeSinceStart() {
        return this.secAccumTime;
    }

    public final float getDuration() {
        return this.secDuration;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.type = type;
    }

    public final float getSecDuration() {
        return this.secDuration;
    }

    public Timer(@NotNull Type type, float secDuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.secDuration = secDuration;
        this.start = System.currentTimeMillis();
        if (this.type != Type.Infinite) {
            boolean bl = this.secDuration > 0.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    public Timer(float secDuration) {
        this(Type.Infinite, 1.0f);
    }

    @Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Luno/time/Timer$Type;", "", "<init>", "(Ljava/lang/String;I)V", "Loop", "Single", "Infinite", "MAX", "core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Loop;
        public static final /* enum */ Type Single;
        public static final /* enum */ Type Infinite;
        public static final /* enum */ Type MAX;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[4];
            Type[] typeArray2 = typeArray;
            typeArray[0] = Loop = new Type();
            typeArray[1] = Single = new Type();
            typeArray[2] = Infinite = new Type();
            typeArray[3] = MAX = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

