/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.handler;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.class_793;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.event.DeserializeModelJsonCallback;
import team.chisel.ctm.client.resource.ModelParser;
import team.chisel.ctm.client.resource.ModelParserV1;

public class DeserializeModelJsonCallbackHandler
implements DeserializeModelJsonCallback {
    private static final Map<Integer, ModelParser> PARSERS = new ImmutableMap.Builder().put((Object)1, (Object)new ModelParserV1()).build();
    private final Map<class_793, Int2ObjectMap<JsonElement>> jsonOverrideMap;

    public DeserializeModelJsonCallbackHandler(Map<class_793, Int2ObjectMap<JsonElement>> jsonOverrideMap) {
        this.jsonOverrideMap = jsonOverrideMap;
    }

    @Override
    public void onDeserializeModelJson(class_793 jsonModel, JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        JsonObject jsonObject;
        if (jsonElement.isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).has("ctm_version")) {
            ModelParser parser = PARSERS.get(jsonObject.get("ctm_version").getAsInt());
            if (parser == null) {
                CTMClient.LOGGER.error("Invalid \"ctm_version\" in model {}.", (Object)jsonElement);
            } else {
                Int2ObjectMap<JsonElement> overrides = parser.parse(jsonModel, jsonObject, type, context);
                if (overrides != null) {
                    this.jsonOverrideMap.put(jsonModel, overrides);
                }
            }
        }
    }
}

