/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.render;

import net.minecraft.class_1058;
import team.chisel.ctm.client.render.Submap;

public class SubmapImpl
implements Submap {
    public static final float FACTOR = 16.0f;
    private static final float DIV3 = 5.3333335f;
    public static final Submap X1 = new SubmapImpl(16.0f, 16.0f, 0.0f, 0.0f);
    public static final Submap[][] X2 = new Submap[][]{{new SubmapImpl(8.0f, 8.0f, 0.0f, 0.0f), new SubmapImpl(8.0f, 8.0f, 8.0f, 0.0f)}, {new SubmapImpl(8.0f, 8.0f, 0.0f, 8.0f), new SubmapImpl(8.0f, 8.0f, 8.0f, 8.0f)}};
    public static final Submap[][] X3 = new Submap[][]{{new SubmapImpl(5.3333335f, 5.3333335f, 0.0f, 0.0f), new SubmapImpl(5.3333335f, 5.3333335f, 5.3333335f, 0.0f), new SubmapImpl(5.3333335f, 5.3333335f, 10.666667f, 0.0f)}, {new SubmapImpl(5.3333335f, 5.3333335f, 0.0f, 5.3333335f), new SubmapImpl(5.3333335f, 5.3333335f, 5.3333335f, 5.3333335f), new SubmapImpl(5.3333335f, 5.3333335f, 10.666667f, 5.3333335f)}, {new SubmapImpl(5.3333335f, 5.3333335f, 0.0f, 10.666667f), new SubmapImpl(5.3333335f, 5.3333335f, 5.3333335f, 10.666667f), new SubmapImpl(5.3333335f, 5.3333335f, 10.666667f, 10.666667f)}};
    public static final Submap[][] X4 = new Submap[][]{{new SubmapImpl(4.0f, 4.0f, 0.0f, 0.0f), new SubmapImpl(4.0f, 4.0f, 4.0f, 0.0f), new SubmapImpl(4.0f, 4.0f, 8.0f, 0.0f), new SubmapImpl(4.0f, 4.0f, 12.0f, 0.0f)}, {new SubmapImpl(4.0f, 4.0f, 0.0f, 4.0f), new SubmapImpl(4.0f, 4.0f, 4.0f, 4.0f), new SubmapImpl(4.0f, 4.0f, 8.0f, 4.0f), new SubmapImpl(4.0f, 4.0f, 12.0f, 4.0f)}, {new SubmapImpl(4.0f, 4.0f, 0.0f, 8.0f), new SubmapImpl(4.0f, 4.0f, 4.0f, 8.0f), new SubmapImpl(4.0f, 4.0f, 8.0f, 8.0f), new SubmapImpl(4.0f, 4.0f, 12.0f, 8.0f)}, {new SubmapImpl(4.0f, 4.0f, 0.0f, 12.0f), new SubmapImpl(4.0f, 4.0f, 4.0f, 12.0f), new SubmapImpl(4.0f, 4.0f, 8.0f, 12.0f), new SubmapImpl(4.0f, 4.0f, 12.0f, 12.0f)}};
    private final float width;
    private final float height;
    private final float xOffset;
    private final float yOffset;
    private final NormalizedSubmap normalized = new NormalizedSubmap(this);

    public SubmapImpl(float width, float height, float xOffset, float yOffset) {
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getXOffset() {
        return this.xOffset;
    }

    @Override
    public float getYOffset() {
        return this.yOffset;
    }

    @Override
    public NormalizedSubmap normalize() {
        return this.normalized;
    }

    @Override
    public Submap relativize() {
        return this;
    }

    @Override
    public float getInterpolatedU(class_1058 sprite, float u) {
        return sprite.method_4580((double)(this.getXOffset() + u / this.getWidth()));
    }

    @Override
    public float getInterpolatedV(class_1058 sprite, float v) {
        return sprite.method_4570((double)(this.getYOffset() + v / this.getWidth()));
    }

    @Override
    public float[] toArray() {
        return new float[]{this.getXOffset(), this.getYOffset(), this.getXOffset() + this.getWidth(), this.getYOffset() + this.getHeight()};
    }

    public NormalizedSubmap getNormalized() {
        return this.normalized;
    }

    public SubmapImpl multiply(Submap submap) {
        Submap normal = submap.normalize();
        float newWidth = this.width * normal.getWidth();
        float newHeight = this.height * normal.getHeight();
        float newXOffset = this.xOffset + normal.getWidth() * submap.getXOffset();
        float newYOffset = this.yOffset + normal.getHeight() * submap.getYOffset();
        return new SubmapImpl(newWidth, newHeight, newXOffset, newYOffset);
    }

    public static Submap getX2Submap(int id) {
        return X2[id / 2][id % 2];
    }

    private static class NormalizedSubmap
    implements Submap {
        private final Submap parent;

        NormalizedSubmap(Submap parent) {
            this.parent = parent;
        }

        @Override
        public float getWidth() {
            return this.parent.getWidth() / 16.0f;
        }

        @Override
        public float getHeight() {
            return this.parent.getHeight() / 16.0f;
        }

        @Override
        public float getXOffset() {
            return this.parent.getXOffset() / 16.0f;
        }

        @Override
        public float getYOffset() {
            return this.parent.getYOffset() / 16.0f;
        }

        @Override
        public Submap normalize() {
            return this;
        }

        @Override
        public Submap relativize() {
            return this.parent;
        }

        @Override
        public float getInterpolatedU(class_1058 sprite, float u) {
            return this.parent.getInterpolatedU(sprite, u);
        }

        @Override
        public float getInterpolatedV(class_1058 sprite, float v) {
            return this.parent.getInterpolatedV(sprite, v);
        }

        @Override
        public float[] toArray() {
            return this.parent.toArray();
        }
    }
}

