/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.CTMTexture;
import team.chisel.ctm.api.client.TextureInfo;
import team.chisel.ctm.api.client.TextureType;
import team.chisel.ctm.client.render.UnbakedQuad;

public abstract class AbstractTexture<T extends TextureType>
implements CTMTexture<T> {
    protected static final ThreadLocal<MaterialFinder> FINDER = ThreadLocal.withInitial(() -> RendererAccess.INSTANCE.getRenderer().materialFinder());
    protected T type;
    @NotNull
    protected class_1058[] sprites;
    protected RenderMaterial material;
    protected boolean hasLight;
    protected int skyLight;
    protected int blockLight;

    public AbstractTexture(T type, TextureInfo info) {
        BlendMode blendMode;
        JsonElement light;
        this.type = type;
        this.sprites = info.getSprites();
        boolean isEmissive = false;
        if (info.getExtraInfo().isPresent() && (light = info.getExtraInfo().get().get("light")) != null) {
            if (light.isJsonPrimitive()) {
                this.hasLight = true;
                this.skyLight = this.blockLight = AbstractTexture.parseLightValue(light);
            } else if (light.isJsonObject()) {
                this.hasLight = true;
                JsonObject lightObject = light.getAsJsonObject();
                this.skyLight = AbstractTexture.parseLightValue(lightObject.get("sky"));
                this.blockLight = AbstractTexture.parseLightValue(lightObject.get("block"));
            }
            if (this.skyLight == 15 && this.blockLight == 15) {
                isEmissive = true;
            }
        }
        if ((blendMode = info.getBlendMode()) != BlendMode.DEFAULT || isEmissive) {
            this.material = FINDER.get().blendMode(0, blendMode).emissive(0, isEmissive).find();
        }
    }

    private static int parseLightValue(@Nullable JsonElement data) {
        if (data != null && data.isJsonPrimitive() && data.getAsJsonPrimitive().isNumber()) {
            return class_3532.method_15340((int)data.getAsInt(), (int)0, (int)15);
        }
        return 0;
    }

    @Override
    public Collection<class_2960> getTextures() {
        return Arrays.stream(this.sprites).map(class_1058::method_4598).collect(Collectors.toList());
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public class_1058 getParticle() {
        return this.sprites[0];
    }

    protected UnbakedQuad unbake(class_777 bakedQuad, class_2350 cullFace) {
        UnbakedQuad quad = new UnbakedQuad(bakedQuad);
        quad.cullFace = cullFace;
        quad.material = this.material;
        if (this.hasLight) {
            quad.setLight(this.skyLight, this.blockLight);
        }
        return quad;
    }
}

