/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.jmoverlay.ftbchunks;

import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import frankv.jmi.JMI;
import frankv.jmi.jmoverlay.JMOverlayManager;
import frankv.jmi.jmoverlay.ToggleableOverlay;
import frankv.jmi.jmoverlay.ftbchunks.ClaimingMode;
import frankv.jmi.jmoverlay.ftbchunks.FTBClaimedChunkData;
import frankv.jmi.util.OverlayHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.RegistryEvent;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public enum ClaimedChunkPolygon implements ToggleableOverlay
{
    INSTANCE;

    private IClientAPI jmAPI = null;
    private final class_310 mc = class_310.method_1551();
    private boolean activated = true;
    private HashMap<ChunkDimPos, PolygonOverlay> chunkOverlays = new HashMap();
    private HashMap<ChunkDimPos, FTBClaimedChunkData> chunkData = new HashMap();
    private HashMap<ChunkDimPos, PolygonOverlay> forceLoadedOverlays = new HashMap();
    private Queue<FTBClaimedChunkData> queue = new LinkedList<FTBClaimedChunkData>();
    private final String buttonLabel = "FTBChunks Overlay";
    private final int order = 1;
    private Boolean shouldToggleAfterOff = false;

    private ClaimedChunkPolygon() {
        JMOverlayManager.INSTANCE.registerOverlay(this);
    }

    @Override
    public void init(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        if (!this.isEnabled()) {
            return;
        }
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::onTeamPropsChanged);
        this.disableFTBChunksStuff();
    }

    private String getPolygonTitleByPlayerPos() {
        if (this.mc.field_1724 == null) {
            return "";
        }
        ChunkDimPos pos = new ChunkDimPos(this.mc.field_1724.field_6002.method_27983(), this.mc.field_1724.method_31476().field_9181, this.mc.field_1724.method_31476().field_9180);
        if (!this.chunkOverlays.containsKey(pos)) {
            return "Wilderness";
        }
        return this.chunkOverlays.get(pos).getTitle();
    }

    private void createPolygonsOnMappingStarted() {
        class_638 level = this.mc.field_1687;
        if (level == null) {
            return;
        }
        this.chunkData.values().forEach(data -> {
            if (!data.chunkDimPos.dimension.equals(level.method_27983())) {
                return;
            }
            this.addChunk((FTBClaimedChunkData)data, (class_5321<class_1937>)level.method_27983());
        });
    }

    private void addChunk(FTBClaimedChunkData data, class_5321<class_1937> dim) {
        ChunkDimPos pos = data.chunkDimPos;
        if (this.chunkOverlays.containsKey(pos)) {
            return;
        }
        this.chunkData.put(pos, data);
        if (!pos.dimension.equals(dim)) {
            return;
        }
        this.chunkOverlays.put(data.chunkDimPos, data.overlay);
        if (this.activated) {
            OverlayHelper.showOverlay((Displayable)data.overlay);
        }
    }

    private void removeChunk(FTBClaimedChunkData data, class_5321<class_1937> dim) {
        ChunkDimPos pos = data.chunkDimPos;
        if (!this.chunkOverlays.containsKey(pos)) {
            return;
        }
        this.chunkData.remove(pos);
        if (!pos.dimension.equals(dim)) {
            return;
        }
        try {
            this.jmAPI.remove((Displayable)this.chunkOverlays.get(pos));
            this.chunkOverlays.remove(pos);
        }
        catch (Throwable t) {
            JMI.LOGGER.error(t.getMessage(), t);
        }
    }

    private void replaceChunk(FTBClaimedChunkData data, class_5321<class_1937> dim) {
        this.removeChunk(data, dim);
        this.addChunk(data, dim);
        if (ClaimingMode.INSTANCE.isActivated()) {
            this.showForceLoaded(data.chunkDimPos, false);
            this.showForceLoaded(data.chunkDimPos, true);
        }
    }

    public void showForceLoadedByArea(boolean show) {
        class_638 level = this.mc.field_1687;
        if (level == null) {
            return;
        }
        if (!show) {
            this.forceLoadedOverlays.keySet().forEach(pos -> this.chunkOverlays.get(pos).setTitle(this.chunkData.get((Object)pos).team.getDisplayName()));
            OverlayHelper.removeOverlays(this.forceLoadedOverlays.values());
            this.forceLoadedOverlays.clear();
            return;
        }
        ClaimingMode.INSTANCE.getArea().forEach(p -> {
            ChunkDimPos chunkDimPos = new ChunkDimPos(level.method_27983(), p.field_9181, p.field_9180);
            this.showForceLoaded(chunkDimPos, true);
        });
    }

    private void showForceLoaded(ChunkDimPos chunkDimPos, boolean show) {
        if (!this.chunkData.containsKey(chunkDimPos)) {
            return;
        }
        FTBClaimedChunkData data = this.chunkData.get(chunkDimPos);
        String teamName = data.team.getDisplayName();
        if (show && data.forceLoaded && !this.forceLoadedOverlays.containsKey(chunkDimPos)) {
            PolygonOverlay claimedOverlay = ClaimingMode.INSTANCE.forceLoadedPolygon(chunkDimPos);
            OverlayHelper.showOverlay((Displayable)claimedOverlay);
            this.forceLoadedOverlays.put(chunkDimPos, claimedOverlay);
            this.chunkOverlays.get(chunkDimPos).setTitle(teamName + "\nForce Loaded");
        } else if (!show && this.forceLoadedOverlays.containsKey(chunkDimPos)) {
            this.jmAPI.remove((Displayable)this.forceLoadedOverlays.get(chunkDimPos));
            this.forceLoadedOverlays.remove(chunkDimPos);
            this.chunkOverlays.get(chunkDimPos).setTitle(teamName);
        }
    }

    private boolean shouldReplace(FTBClaimedChunkData data) {
        if (data.team == null) {
            return false;
        }
        FTBClaimedChunkData that = this.chunkData.get(data.chunkDimPos);
        if (that == null) {
            return false;
        }
        return !data.equals(that);
    }

    private void disableFTBChunksStuff() {
        if (!JMI.clientConfig.getDisableFTBFunction().booleanValue()) {
            return;
        }
        FTBChunksClientConfig.DEATH_WAYPOINTS.set((Object)false);
        FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)false);
        FTBChunksClientConfig.IN_WORLD_WAYPOINTS.set((Object)false);
    }

    private void clearOverlays() {
        this.chunkOverlays.clear();
        this.forceLoadedOverlays.clear();
    }

    private void onTeamPropsChanged(ClientTeamPropertiesChangedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        UUID teamId = event.getTeam().getId();
        class_5321 dim = this.mc.field_1687.method_27983();
        new HashSet<FTBClaimedChunkData>(this.chunkData.values()).forEach(data -> {
            if (!data.teamId.equals(teamId)) {
                return;
            }
            data.updateOverlayProps();
            this.replaceChunk((FTBClaimedChunkData)data, (class_5321<class_1937>)dim);
        });
    }

    public void onClientTick() {
        if (!this.isEnabled() || !JMI.clientConfig.getFtbChunks().booleanValue()) {
            return;
        }
        if (this.mc.field_1687 == null) {
            return;
        }
        for (int i = 0; i < 200; ++i) {
            if (this.queue == null || this.queue.isEmpty()) {
                return;
            }
            class_5321 playerDim = this.mc.field_1687.method_27983();
            FTBClaimedChunkData data = this.queue.poll();
            if (data.team == null) {
                this.removeChunk(data, (class_5321<class_1937>)playerDim);
                continue;
            }
            if (this.shouldReplace(data)) {
                this.replaceChunk(data, (class_5321<class_1937>)playerDim);
                continue;
            }
            this.addChunk(data, (class_5321<class_1937>)playerDim);
        }
    }

    void onClaiming(boolean off) {
        if (!off && this.activated) {
            return;
        }
        if (!off) {
            this.toggleOverlay();
            this.shouldToggleAfterOff = true;
        } else if (this.shouldToggleAfterOff.booleanValue()) {
            this.toggleOverlay();
            this.shouldToggleAfterOff = false;
        }
    }

    private void toggleOverlay() {
        if (this.activated) {
            OverlayHelper.removeOverlays(this.chunkOverlays.values());
        } else {
            OverlayHelper.showOverlays(this.chunkOverlays.values());
        }
        this.activated = !this.activated;
    }

    @Override
    public void onToggle(IThemeButton button) {
        if (ClaimingMode.INSTANCE.isActivated()) {
            return;
        }
        this.toggleOverlay();
        button.setToggled(Boolean.valueOf(this.activated));
    }

    @Override
    public void onJMEvent(ClientEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        switch (event.type) {
            case MAPPING_STARTED: {
                if (JMI.platformEventListener.isFirstLogin()) break;
                this.createPolygonsOnMappingStarted();
                JMI.LOGGER.debug("re-add ftbchunks overlays");
                break;
            }
            case MAPPING_STOPPED: {
                this.clearOverlays();
                break;
            }
            case REGISTRY: {
                RegistryEvent registryEvent = (RegistryEvent)event;
                switch (registryEvent.getRegistryType()) {
                    case INFO_SLOT: {
                        ((RegistryEvent.InfoSlotRegistryEvent)registryEvent).register("jmi", "jmi.infoslot.ftbchunks", 1000L, this::getPolygonTitleByPlayerPos);
                    }
                }
            }
        }
    }

    public void addToQueue(MapDimension dim, SendChunkPacket.SingleChunk chunk, UUID teamId) {
        if (!JMI.ftbchunks) {
            return;
        }
        this.queue.offer(new FTBClaimedChunkData(dim, chunk, teamId));
    }

    @Override
    public boolean isEnabled() {
        return JMI.ftbchunks;
    }

    @Override
    public String getButtonIconName() {
        return "ftb";
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    public HashMap<ChunkDimPos, PolygonOverlay> getChunkOverlays() {
        return this.chunkOverlays;
    }

    public HashMap<ChunkDimPos, FTBClaimedChunkData> getChunkData() {
        return this.chunkData;
    }

    public HashMap<ChunkDimPos, PolygonOverlay> getForceLoadedOverlays() {
        return this.forceLoadedOverlays;
    }

    @Override
    public String getButtonLabel() {
        return this.buttonLabel;
    }

    @Override
    public int getOrder() {
        return this.order;
    }
}

