/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import java.util.Random;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.EmissiveSpriteApi;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.model.CullingCache;
import me.pepperbell.continuity.client.model.ModelObjectsContainer;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4696;

public class EmissiveBakedModel
extends ForwardingBakedModel {
    protected static final RenderMaterial[] EMISSIVE_MATERIALS;
    protected static final RenderMaterial DEFAULT_EMISSIVE_MATERIAL;
    protected static final RenderMaterial CUTOUT_MIPPED_EMISSIVE_MATERIAL;

    public EmissiveBakedModel(class_1087 wrapped) {
        this.wrapped = wrapped;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getConnectedTexturesState().isEnabled()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        EmissiveBlockQuadTransform quadTransform = container.emissiveBlockQuadTransform;
        if (quadTransform.isActive()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        MeshBuilder meshBuilder = container.meshBuilder;
        quadTransform.prepare(meshBuilder.getEmitter(), blockView, state, pos, (Boolean)ContinuityConfig.INSTANCE.useManualCulling.get());
        context.pushTransform((RenderContext.QuadTransform)quadTransform);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
        if (quadTransform.didEmit()) {
            context.meshConsumer().accept(meshBuilder.build());
        }
        quadTransform.reset();
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
        if (!((Boolean)ContinuityConfig.INSTANCE.emissiveTextures.get()).booleanValue()) {
            super.emitItemQuads(stack, randomSupplier, context);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getEmissiveTexturesState().isEnabled()) {
            super.emitItemQuads(stack, randomSupplier, context);
            return;
        }
        EmissiveItemQuadTransform quadTransform = container.emissiveItemQuadTransform;
        if (quadTransform.isActive()) {
            super.emitItemQuads(stack, randomSupplier, context);
            return;
        }
        MeshBuilder meshBuilder = container.meshBuilder;
        quadTransform.prepare(meshBuilder.getEmitter());
        context.pushTransform((RenderContext.QuadTransform)quadTransform);
        super.emitItemQuads(stack, randomSupplier, context);
        context.popTransform();
        if (quadTransform.didEmit()) {
            context.meshConsumer().accept(meshBuilder.build());
        }
        quadTransform.reset();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    static {
        BlendMode[] blendModes = BlendMode.values();
        EMISSIVE_MATERIALS = new RenderMaterial[blendModes.length];
        MaterialFinder finder = RenderUtil.getMaterialFinder();
        for (BlendMode blendMode : blendModes) {
            EmissiveBakedModel.EMISSIVE_MATERIALS[blendMode.ordinal()] = finder.emissive(0, true).disableDiffuse(0, true).disableAo(0, true).blendMode(0, blendMode).find();
        }
        DEFAULT_EMISSIVE_MATERIAL = EMISSIVE_MATERIALS[BlendMode.DEFAULT.ordinal()];
        CUTOUT_MIPPED_EMISSIVE_MATERIAL = EMISSIVE_MATERIALS[BlendMode.CUTOUT_MIPPED.ordinal()];
    }

    protected static class EmissiveBlockQuadTransform
    implements RenderContext.QuadTransform {
        protected final CullingCache cullingCache = new CullingCache();
        protected QuadEmitter emitter;
        protected class_1920 blockView;
        protected class_2680 state;
        protected class_2338 pos;
        protected boolean useManualCulling;
        protected boolean active;
        protected boolean didEmit;
        protected boolean calculateDefaultLayer;
        protected boolean isDefaultLayerSolid;

        protected EmissiveBlockQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            if (this.useManualCulling && this.cullingCache.shouldCull((QuadView)quad, this.blockView, this.pos, this.state)) {
                return false;
            }
            class_1058 sprite = RenderUtil.getSpriteFinder().find((QuadView)quad, 0);
            class_1058 emissiveSprite = EmissiveSpriteApi.get().getEmissiveSprite(sprite);
            if (emissiveSprite != null) {
                RenderMaterial emissiveMaterial;
                quad.copyTo((MutableQuadView)this.emitter);
                BlendMode blendMode = RenderUtil.getBlendMode((QuadView)quad);
                if (blendMode == BlendMode.DEFAULT) {
                    if (this.calculateDefaultLayer) {
                        this.isDefaultLayerSolid = class_4696.method_23679((class_2680)this.state) == class_1921.method_23577();
                        this.calculateDefaultLayer = false;
                    }
                    emissiveMaterial = this.isDefaultLayerSolid ? CUTOUT_MIPPED_EMISSIVE_MATERIAL : DEFAULT_EMISSIVE_MATERIAL;
                } else {
                    emissiveMaterial = blendMode == BlendMode.SOLID ? CUTOUT_MIPPED_EMISSIVE_MATERIAL : EMISSIVE_MATERIALS[blendMode.ordinal()];
                }
                this.emitter.material(emissiveMaterial);
                QuadUtil.interpolate((MutableQuadView)this.emitter, sprite, emissiveSprite);
                this.emitter.emit();
                this.didEmit = true;
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean didEmit() {
            return this.didEmit;
        }

        public void prepare(QuadEmitter emitter, class_1920 blockView, class_2680 state, class_2338 pos, boolean useManualCulling) {
            this.emitter = emitter;
            this.blockView = blockView;
            this.state = state;
            this.pos = pos;
            this.useManualCulling = useManualCulling;
            this.active = true;
            this.didEmit = false;
            this.calculateDefaultLayer = true;
            this.isDefaultLayerSolid = false;
            this.cullingCache.prepare();
        }

        public void reset() {
            this.emitter = null;
            this.blockView = null;
            this.state = null;
            this.pos = null;
            this.useManualCulling = false;
            this.active = false;
        }
    }

    protected static class EmissiveItemQuadTransform
    implements RenderContext.QuadTransform {
        protected QuadEmitter emitter;
        protected boolean active;
        protected boolean didEmit;

        protected EmissiveItemQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            class_1058 sprite = RenderUtil.getSpriteFinder().find((QuadView)quad, 0);
            class_1058 emissiveSprite = EmissiveSpriteApi.get().getEmissiveSprite(sprite);
            if (emissiveSprite != null) {
                quad.copyTo((MutableQuadView)this.emitter);
                this.emitter.material(DEFAULT_EMISSIVE_MATERIAL);
                QuadUtil.interpolate((MutableQuadView)this.emitter, sprite, emissiveSprite);
                this.emitter.emit();
                this.didEmit = true;
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean didEmit() {
            return this.didEmit;
        }

        public void prepare(QuadEmitter emitter) {
            this.emitter = emitter;
            this.active = true;
            this.didEmit = false;
        }

        public void reset() {
            this.active = false;
            this.emitter = null;
        }
    }
}

