/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties.overlay;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_151;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class OverlayPropertiesSection {
    protected Properties properties;
    protected class_2960 id;
    protected String packName;
    protected int tintIndex = -1;
    protected class_2680 tintBlock;
    protected BlendMode layer = BlendMode.CUTOUT_MIPPED;

    public OverlayPropertiesSection(Properties properties, class_2960 id, String packName) {
        this.properties = properties;
        this.id = id;
        this.packName = packName;
    }

    public void init() {
        this.parseTintIndex();
        this.parseTintBlock();
        this.parseLayer();
    }

    protected void parseTintIndex() {
        String tintIndexStr = this.properties.getProperty("tintIndex");
        if (tintIndexStr != null) {
            try {
                int tintIndex = Integer.parseInt(tintIndexStr.trim());
                if (tintIndex >= 0) {
                    this.tintIndex = tintIndex;
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ContinuityClient.LOGGER.warn("Invalid 'tintIndex' value '" + tintIndexStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
        }
    }

    protected void parseTintBlock() {
        String[] parts;
        String tintBlockStr = this.properties.getProperty("tintBlock");
        if (tintBlockStr != null && (parts = tintBlockStr.trim().split(":", 3)).length != 0) {
            class_2960 blockId;
            try {
                blockId = parts.length == 1 || parts[1].contains("=") ? new class_2960(parts[0]) : new class_2960(parts[0], parts[1]);
            }
            catch (class_151 e) {
                ContinuityClient.LOGGER.warn("Invalid 'tintBlock' value '" + tintBlockStr + "' in file '" + this.id + "' in pack '" + this.packName + "'", (Throwable)e);
                return;
            }
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(blockId);
            if (block != class_2246.field_10124) {
                this.tintBlock = block.method_9564();
            } else {
                ContinuityClient.LOGGER.warn("Unknown block '" + blockId + "' in 'tintBlock' value '" + tintBlockStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
            }
        }
    }

    protected void parseLayer() {
        String layerStr = this.properties.getProperty("layer");
        if (layerStr != null) {
            switch (layerStr = layerStr.trim().toLowerCase(Locale.ROOT)) {
                case "cutout_mipped": {
                    this.layer = BlendMode.CUTOUT_MIPPED;
                    break;
                }
                case "cutout": {
                    this.layer = BlendMode.CUTOUT;
                    break;
                }
                case "translucent": {
                    this.layer = BlendMode.TRANSLUCENT;
                    break;
                }
                default: {
                    ContinuityClient.LOGGER.warn("Unknown 'layer' value '" + layerStr + " in file '" + this.id + "' in pack '" + this.packName + "'");
                }
            }
        }
    }

    public int getTintIndex() {
        return this.tintIndex;
    }

    public class_2680 getTintBlock() {
        return this.tintBlock;
    }

    public BlendMode getLayer() {
        return this.layer;
    }

    public static interface Provider {
        public OverlayPropertiesSection getOverlayPropertiesSection();
    }
}

