/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.collect.ImmutableSortedMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.api.event.fabric.EntityRadarUpdateEvent;
import journeymap.client.data.DataCache;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.mod.impl.Pixelmon;
import journeymap.client.model.EntityDTO;
import journeymap.client.render.RenderFacade;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1427;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1498;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1646;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_887;
import net.minecraft.class_897;
import net.minecraft.class_910;
import net.minecraft.class_963;

public class EntityHelper {
    public static EntityDistanceComparator entityDistanceComparator = new EntityDistanceComparator();
    public static EntityDTODistanceComparator entityDTODistanceComparator = new EntityDTODistanceComparator();
    public static EntityMapComparator entityMapComparator = new EntityMapComparator();
    private static final String[] HORSE_TEXTURES = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};

    public static List<EntityDTO> getEntitiesNearby(String timerName, int maxEntities, boolean hostile, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        class_310 mc = class_310.method_1551();
        List<EntityDTO> list = new ArrayList<EntityDTO>();
        ArrayList allEntities = new ArrayList();
        mc.field_1687.method_18112().forEach(allEntities::add);
        class_238 bb = EntityHelper.getBB((class_1657)mc.field_1724);
        try {
            block2: for (class_1297 entity : allEntities) {
                if (!(entity instanceof class_1309) || !entity.method_5805() || !bb.method_994(entity.method_5829())) continue;
                for (Class entityClass : entityClasses) {
                    if (!entityClass.isAssignableFrom(entity.getClass()) || !EntityHelper.isSpecialCreature(entity, hostile)) continue;
                    class_1309 entityLivingBase = (class_1309)entity;
                    EntityDTO dto = DataCache.INSTANCE.getEntityDTO(entityLivingBase);
                    dto.update(entityLivingBase, hostile);
                    if (!CustomEventDispatcher.getInstance().entityRadarUpdateEvent(EntityRadarUpdateEvent.EntityType.MOB, dto)) continue block2;
                    list.add(dto);
                    continue block2;
                }
            }
            if (list.size() > maxEntities) {
                int before2 = list.size();
                EntityHelper.entityDTODistanceComparator.player = mc.field_1724;
                Collections.sort(list, entityDTODistanceComparator);
                list = list.subList(0, maxEntities);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    private static boolean isSpecialCreature(class_1297 entity, boolean hostile) {
        if (class_1314.class.isAssignableFrom(entity.getClass())) {
            if (hostile && entity.method_5864().method_5891().equals((Object)class_1311.field_6302)) {
                return true;
            }
            return !hostile && entity.method_5864().method_5891().method_6136();
        }
        return true;
    }

    public static List<EntityDTO> getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", JourneymapClient.getInstance().getCoreProperties().maxMobsData.get(), true, class_1569.class, class_1314.class);
    }

    public static List<EntityDTO> getVillagersNearby() {
        return EntityHelper.getEntitiesNearby("getVillagersNearby", JourneymapClient.getInstance().getCoreProperties().maxVillagersData.get(), false, class_1646.class, class_1655.class);
    }

    public static List<EntityDTO> getAnimalsNearby() {
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", JourneymapClient.getInstance().getCoreProperties().maxAnimalsData.get(), false, class_1429.class, class_1427.class, class_1480.class, class_1314.class);
    }

    public static boolean isPassive(class_1309 entityLiving) {
        if (entityLiving == null) {
            return false;
        }
        if (entityLiving instanceof class_1569) {
            return false;
        }
        class_1309 attackTarget = entityLiving.method_6124();
        return attackTarget == null || !(attackTarget instanceof class_1657) && !(attackTarget instanceof class_1321);
    }

    public static List<EntityDTO> getPlayersNearby() {
        StatTimer timer = StatTimer.get("EntityHelper.getPlayersNearby");
        timer.start();
        class_310 mc = class_310.method_1551();
        List<class_1657> allPlayers = new ArrayList();
        if (JourneymapClient.getInstance().getStateHandler().isExpandedRadarEnabled()) {
            if (mc.method_1562().method_2880() != null && mc.method_1562().method_2880().size() > 1) {
                for (class_640 onlinePlayer : mc.method_1562().method_2880()) {
                    class_1657 networkedPlayer;
                    if (onlinePlayer.method_2966().getId().equals(mc.field_1724.method_5667()) || (networkedPlayer = PlayerRadarManager.getInstance().getPlayers().get(onlinePlayer.method_2966().getId())) == null || networkedPlayer.field_6002.method_27983() != class_310.method_1551().field_1724.field_6002.method_27983()) continue;
                    allPlayers.add(networkedPlayer);
                }
            }
        } else {
            allPlayers.addAll(mc.field_1687.method_18456());
            allPlayers.remove(mc.field_1724);
        }
        int max = JourneymapClient.getInstance().getCoreProperties().maxPlayersData.get();
        if (allPlayers.size() > max) {
            EntityHelper.entityDistanceComparator.player = mc.field_1724;
            Collections.sort(allPlayers, entityDistanceComparator);
            allPlayers = allPlayers.subList(0, max);
        }
        ArrayList<EntityDTO> playerDTOs = new ArrayList<EntityDTO>(allPlayers.size());
        for (class_1657 player : allPlayers) {
            EntityDTO dto = DataCache.INSTANCE.getEntityDTO((class_1309)player);
            dto.update((class_1309)player, false);
            if (!CustomEventDispatcher.getInstance().entityRadarUpdateEvent(EntityRadarUpdateEvent.EntityType.PLAYER, dto)) continue;
            playerDTOs.add(dto);
        }
        timer.stop();
        return playerDTOs;
    }

    private static class_238 getBB(class_1657 player) {
        int lateralDistance = JourneymapClient.getInstance().getCoreProperties().radarLateralDistance.get();
        int verticalDistance = JourneymapClient.getInstance().getCoreProperties().radarVerticalDistance.get();
        return EntityHelper.getBoundingBox(player, lateralDistance, verticalDistance);
    }

    public static class_238 getBoundingBox(class_1657 player, double lateralDistance, double verticalDistance) {
        return player.method_5829().method_1009(lateralDistance, verticalDistance, lateralDistance);
    }

    public static Map<String, EntityDTO> buildEntityIdMap(List<? extends EntityDTO> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, new EntityMapComparator());
        }
        LinkedHashMap<CallSite, EntityDTO> idMap = new LinkedHashMap<CallSite, EntityDTO>(list.size());
        for (EntityDTO entityDTO : list) {
            idMap.put((CallSite)((Object)("id" + entityDTO.entityId)), entityDTO);
        }
        return ImmutableSortedMap.copyOf(idMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static class_2960 getIconTextureLocation(class_1297 entity) {
        try {
            class_897 entityRender = class_310.method_1551().method_1561().method_3953(entity);
            class_2960 original = null;
            if (entityRender instanceof class_887) {
                class_1548 creeper = (class_1548)entity;
                original = entityRender.method_3931((class_1297)creeper);
                if (creeper.method_6872()) {
                    String path = original.method_12832().replace("creeper.png", "creeper_armor.png");
                    original = new class_2960(original.method_12836(), path);
                }
            } else if (entityRender instanceof class_963) {
                class_1646 villager = (class_1646)entity;
                original = entityRender.method_3931((class_1297)villager);
                String profession = villager.method_7231().method_16924().method_35202();
                String poiProfession = villager.method_7231().method_16924().method_19198().method_35158();
                boolean hasTexture = false;
                if (poiProfession.contains(":")) {
                    String namespace = poiProfession.split(":")[0];
                    String path = poiProfession.split(":")[1];
                    String poiJobPath = original.method_12832().replace("villager.png", path + ".png");
                    class_2960 profPoiResource = new class_2960(namespace, poiJobPath);
                    hasTexture = class_310.method_1551().method_1478().method_18234(profPoiResource);
                    if (hasTexture) {
                        original = profPoiResource;
                    } else {
                        if (profession.contains(":")) {
                            namespace = profession.split(":")[0];
                            path = profession.split(":")[1];
                        } else {
                            path = profession;
                        }
                        path = original.method_12832().replace("villager.png", path + ".png");
                        class_2960 profResource = new class_2960(namespace, path);
                        class_310.method_1551().method_1478().method_18234(profResource);
                        original = profResource;
                    }
                } else if ("minecraft".equals(original.method_12836()) && !"unemployed".equals(poiProfession)) {
                    String path = original.method_12832().replace("villager.png", poiProfession + ".png");
                    original = new class_2960(original.method_12836(), path);
                }
            } else if (entityRender instanceof class_910) {
                class_1498 horse = (class_1498)entity;
                original = entityRender.method_3931((class_1297)horse);
            } else if (Pixelmon.loaded) {
                original = Pixelmon.INSTANCE.getPixelmonResource(entity);
                if (original != null) return original;
                original = RenderFacade.getEntityTexture(entityRender, entity);
            } else {
                original = RenderFacade.getEntityTexture(entityRender, entity);
            }
            if (original == null) {
                JMLogger.logOnce("Can't get entityTexture for " + entity.getClass() + " via " + entityRender.getClass());
                return null;
            }
            if (!original.method_12832().contains("/entity/")) {
                JMLogger.logOnce(original + " doesn't have /entity/ in path, so can't look for /entity_icon/");
                return null;
            }
            class_2960 entityIconLoc = original.method_12832().contains("/model/entity/") ? new class_2960(original.method_12836(), original.method_12832().replace("/model/entity/", "/entity_icon/")) : (original.method_12832().contains("/model/") && !original.method_12832().contains("/entity/") ? new class_2960(original.method_12836(), original.method_12832().replace("/model/", "/entity_icon/")) : new class_2960(original.method_12836(), original.method_12832().replace("/entity/", "/entity_icon/")));
            if (class_310.method_1551().method_1478().method_18234(entityIconLoc)) return entityIconLoc;
            JMLogger.logOnce("Can't get entityTexture for " + entityIconLoc);
            return null;
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Can't get entityTexture for " + entity.method_5477(), t);
            return null;
        }
    }

    private static class EntityDTODistanceComparator
    implements Comparator<EntityDTO> {
        class_1657 player;

        private EntityDTODistanceComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            class_1309 e1 = (class_1309)o1.entityLivingRef.get();
            class_1309 e2 = (class_1309)o2.entityLivingRef.get();
            if (e1 == null || e2 == null) {
                return 0;
            }
            return Double.compare(e1.method_5858((class_1297)this.player), e2.method_5858((class_1297)this.player));
        }
    }

    private static class EntityDistanceComparator
    implements Comparator<class_1297> {
        class_1657 player;

        private EntityDistanceComparator() {
        }

        @Override
        public int compare(class_1297 o1, class_1297 o2) {
            return Double.compare(o1.method_5858((class_1297)this.player), o2.method_5858((class_1297)this.player));
        }
    }

    private static class EntityMapComparator
    implements Comparator<EntityDTO> {
        private EntityMapComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Integer n;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.getCustomName() != null) {
                n = o1rank;
                o1rank = o1rank + 1;
            } else if (o1.username != null) {
                o1rank = o1rank + 2;
            }
            if (o2.getCustomName() != null) {
                n = o2rank;
                o2rank = o2rank + 1;
            } else if (o2.username != null) {
                o2rank = o2rank + 2;
            }
            return o1rank.compareTo(o2rank);
        }
    }
}

