/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import info.journeymap.shaded.earcut4j.Earcut;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.TextProperties;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Shape;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class DrawPolygonStep
extends BaseOverlayDrawStep<PolygonOverlay> {
    protected List<Point2D.Double> fillPoints = new ArrayList<Point2D.Double>();
    protected List<List<Point2D.Double>> strokePoints = new ArrayList<List<Point2D.Double>>();
    boolean doRender = true;
    boolean onScreen;

    public DrawPolygonStep(PolygonOverlay polygon) {
        super(polygon);
    }

    @Override
    public void draw(class_4587 poseStack, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
                this.onScreen = false;
                return;
            }
            this.onScreen = this.isOnScreen(poseStack, xOffset, yOffset, gridRenderer, rotation);
            if (this.onScreen && this.doRender) {
                DrawUtil.drawPolygon(poseStack, xOffset, yOffset, this.fillPoints, this.strokePoints, ((PolygonOverlay)this.overlay).getShapeProperties(), gridRenderer.getZoom());
            }
        } else if (this.onScreen && this.doRender && this.isTextInMinimap(gridRenderer)) {
            super.drawText(poseStack, buffers, pass, xOffset, yOffset, gridRenderer, fontScale, rotation);
        }
    }

    private boolean isTextInMinimap(GridRenderer gridRenderer) {
        if (gridRenderer.getUIState().ui == Context.UI.Minimap) {
            class_310 mc = class_310.method_1551();
            DisplayVars dv = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            Point2D.Double centerPoint = gridRenderer.getPixel(mc.field_1724.method_23317(), mc.field_1724.method_23321());
            Rectangle2D.Double centerRect = new Rectangle2D.Double(((Point2D)centerPoint).getX() - (double)(dv.minimapWidth / 2), ((Point2D)centerPoint).getY() - (double)(dv.minimapHeight / 2), dv.minimapWidth, dv.minimapHeight);
            if (dv.getShape() == Shape.Circle) {
                return centerPoint.distance(this.labelPosition) < (double)(dv.minimapWidth / 2);
            }
            return centerRect.contains(gridRenderer.getWindowPosition(this.labelPosition));
        }
        return true;
    }

    @Override
    protected void updatePositions(class_4587 poseStack, GridRenderer gridRenderer, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            return;
        }
        if (Context.UI.Minimap == gridRenderer.getUIState().ui) {
            class_243 playerPos = class_310.method_1551().field_1724.method_19538();
            int zoom = gridRenderer.getZoom() <= 1 ? 2 : gridRenderer.getZoom();
            int limit = gridRenderer.getGridSize() * 512 / zoom;
            if (!((class_2338)((PolygonOverlay)this.overlay).getOuterArea().getPoints().get(0)).method_19771(new class_2382(playerPos.method_10216(), playerPos.method_10214(), playerPos.method_10215()), (double)limit)) {
                this.doRender = false;
                return;
            }
        }
        this.doRender = true;
        List<class_2338> points = DataCache.INSTANCE.getTriangulation((PolygonOverlay)this.overlay);
        this.fillPoints.clear();
        for (class_2338 pos : points) {
            Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(pos);
            if (this.fillPoints.isEmpty()) {
                this.screenBounds.setRect(pixel.x, pixel.y, 1.0, 1.0);
            } else {
                this.screenBounds.add(pixel);
            }
            this.fillPoints.add(pixel);
        }
        this.strokePoints.clear();
        this.strokePoints.add(DrawPolygonStep.toScreen(gridRenderer, ((PolygonOverlay)this.overlay).getOuterArea()));
        if (((PolygonOverlay)this.overlay).getHoles() != null) {
            for (MapPolygon hole : ((PolygonOverlay)this.overlay).getHoles()) {
                this.strokePoints.add(DrawPolygonStep.toScreen(gridRenderer, hole));
            }
        }
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    private static List<Point2D.Double> toScreen(@NotNull GridRenderer gridRenderer, @NotNull MapPolygon polygon) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        for (class_2338 pos : polygon.getPoints()) {
            points.add(gridRenderer.getBlockPixelInGrid(pos));
        }
        return points;
    }

    public static List<MapPolygon> triangulate(@NotNull PolygonOverlay overlay) {
        List holesList = Optional.ofNullable(overlay.getHoles()).orElse(new ArrayList());
        List blockPoints = Stream.concat(overlay.getOuterArea().getPoints().stream(), holesList.stream().flatMap(hole -> hole.getPoints().stream())).collect(Collectors.toList());
        double[] points = new double[blockPoints.size() * 2];
        for (int index = 0; index < blockPoints.size(); ++index) {
            points[index * 2] = ((class_2338)blockPoints.get(index)).method_10263();
            points[index * 2 + 1] = ((class_2338)blockPoints.get(index)).method_10260();
        }
        int[] holes = new int[holesList.size()];
        int holeIndex = overlay.getOuterArea().getPoints().size();
        for (int index = 0; index < holesList.size(); ++index) {
            holes[index] = holeIndex;
            holeIndex += ((MapPolygon)holesList.get(index)).getPoints().size();
        }
        List<Integer> triangles = Earcut.earcut(points, holes, 2);
        ArrayList<MapPolygon> trianglePolys = new ArrayList<MapPolygon>();
        for (int index = 0; index < triangles.size(); index += 3) {
            ArrayList<class_2338> trianglePoints = new ArrayList<class_2338>();
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index + 2)));
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index + 1)));
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index)));
            trianglePolys.add(new MapPolygon(trianglePoints));
        }
        return trianglePolys;
    }

    public static class SimpleCacheLoader
    extends CacheLoader<PolygonOverlay, DrawPolygonStep> {
        public DrawPolygonStep load(PolygonOverlay overlay) throws Exception {
            return new DrawPolygonStep(overlay);
        }
    }

    public static class TriangulationCacheLoader
    extends CacheLoader<PolygonOverlay, List<class_2338>> {
        public List<class_2338> load(PolygonOverlay overlay) throws Exception {
            return DrawPolygonStep.triangulate(overlay).stream().flatMap(poly -> poly.getPoints().stream()).collect(Collectors.toList());
        }
    }
}

