/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import dev.architectury.registry.registries.RegistrySupplier;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;

public abstract class BuilderBase<T>
implements Supplier<T> {
    public final class_2960 id;
    private RegistrySupplier<T> object;
    public String translationKey;
    public String displayName;
    public transient boolean dummyBuilder;
    public transient Set<class_2960> defaultTags;

    public BuilderBase(class_2960 i) {
        this.id = i;
        this.object = null;
        this.translationKey = this.getTranslationKeyGroup() + "." + this.id.method_12836() + "." + this.id.method_12832();
        this.displayName = Arrays.stream(this.id.method_12832().split("_")).map(UtilsJS::toTitleCase).collect(Collectors.joining(" "));
        this.dummyBuilder = false;
        this.defaultTags = new HashSet<class_2960>();
    }

    public abstract RegistryObjectBuilderTypes<? super T> getRegistryType();

    public abstract T createObject();

    public final BuilderBase<T> type(String type) {
        throw new RuntimeException("type(String type) is no longer supported! Use event.create(String id, String type) now!");
    }

    public T transformObject(T obj) {
        return obj;
    }

    @Override
    public final T get() {
        try {
            return (T)this.object.get();
        }
        catch (Exception ex) {
            if (this.dummyBuilder) {
                throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().registryKey.method_29177() + "' is from a dummy builder and doesn't have a value!");
            }
            throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().registryKey.method_29177() + "' hasn't been registered yet!");
        }
    }

    public void createAdditionalObjects() {
    }

    public String getTranslationKeyGroup() {
        return this.getRegistryType().registryKey.method_29177().method_12832();
    }

    public BuilderBase<T> translationKey(String key) {
        this.translationKey = key;
        return this;
    }

    public BuilderBase<T> displayName(String name) {
        this.displayName = name;
        return this;
    }

    public BuilderBase<T> tag(class_2960 tag) {
        this.defaultTags.add(tag);
        return this;
    }

    public class_2960 newID(String pre, String post) {
        if (pre.isEmpty() && post.isEmpty()) {
            return this.id;
        }
        return new class_2960(this.id.method_12836() + ":" + pre + this.id.method_12832() + post);
    }

    public void generateDataJsons(DataJsonGenerator generator) {
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
    }

    public void generateLang(Map<String, String> lang) {
        lang.put(this.translationKey, this.displayName);
    }

    @Environment(value=EnvType.CLIENT)
    public void clientRegistry(Supplier<class_310> minecraft) {
    }

    public void addResourcePackLocations(String path, List<class_2960> list, class_3264 packType) {
    }

    private T createTransformedObject() {
        this.getRegistryType().current = this;
        T o = this.transformObject(this.createObject());
        this.getRegistryType().current = null;
        return o;
    }

    final boolean registerObject(boolean all) {
        if (!this.dummyBuilder && (all || this.getRegistryType().bypassServerOnly)) {
            if (CommonProperties.get().debugInfo) {
                ConsoleJS.STARTUP.info("+ " + this.getRegistryType().registryKey.method_29177() + " | " + this.id);
            }
            this.object = this.getRegistryType().deferredRegister.register(this.id, this::createTransformedObject);
            return true;
        }
        return false;
    }

    protected final RegistrySupplier<T> asRegistrySupplier() {
        return Objects.requireNonNull(this.object, () -> "Object '%s' of registry '%s' hasn't been registered yet!".formatted(this.id, this.getRegistryType().registryKey.method_29177()));
    }
}

