/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.bindings.BlockWrapper;
import dev.latvian.mods.kubejs.bindings.ComponentWrapper;
import dev.latvian.mods.kubejs.bindings.IngredientWrapper;
import dev.latvian.mods.kubejs.bindings.ItemWrapper;
import dev.latvian.mods.kubejs.bindings.UtilsWrapper;
import dev.latvian.mods.kubejs.block.DetectorBlock;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.block.custom.BasicBlockJS;
import dev.latvian.mods.kubejs.block.custom.CropBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.FallingBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.FenceBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.FenceGateBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.SlabBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.StairBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.StoneButtonBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.StonePressurePlateBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.WallBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.WoodenButtonBlockBuilder;
import dev.latvian.mods.kubejs.block.custom.WoodenPressurePlateBlockBuilder;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.screen.AtlasTextureObject;
import dev.latvian.mods.kubejs.client.painter.screen.GradientObject;
import dev.latvian.mods.kubejs.client.painter.screen.ItemObject;
import dev.latvian.mods.kubejs.client.painter.screen.RectangleObject;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenGroup;
import dev.latvian.mods.kubejs.client.painter.screen.TextObject;
import dev.latvian.mods.kubejs.core.PlayerSelector;
import dev.latvian.mods.kubejs.event.DataEvent;
import dev.latvian.mods.kubejs.event.EventsJS;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder;
import dev.latvian.mods.kubejs.item.custom.AxeItemBuilder;
import dev.latvian.mods.kubejs.item.custom.BasicItemJS;
import dev.latvian.mods.kubejs.item.custom.HoeItemBuilder;
import dev.latvian.mods.kubejs.item.custom.ItemArmorTierEventJS;
import dev.latvian.mods.kubejs.item.custom.ItemToolTierEventJS;
import dev.latvian.mods.kubejs.item.custom.PickaxeItemBuilder;
import dev.latvian.mods.kubejs.item.custom.RecordItemJS;
import dev.latvian.mods.kubejs.item.custom.ShovelItemBuilder;
import dev.latvian.mods.kubejs.item.custom.SwordItemBuilder;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter;
import dev.latvian.mods.kubejs.level.gen.filter.mob.MobFilter;
import dev.latvian.mods.kubejs.misc.BasicMobEffect;
import dev.latvian.mods.kubejs.misc.CustomStatBuilder;
import dev.latvian.mods.kubejs.misc.EnchantmentBuilder;
import dev.latvian.mods.kubejs.misc.MotiveBuilder;
import dev.latvian.mods.kubejs.misc.ParticleTypeBuilder;
import dev.latvian.mods.kubejs.misc.PoiTypeBuilder;
import dev.latvian.mods.kubejs.misc.PotionBuilder;
import dev.latvian.mods.kubejs.misc.SoundEventBuilder;
import dev.latvian.mods.kubejs.misc.VillagerProfessionBuilder;
import dev.latvian.mods.kubejs.misc.VillagerTypeBuilder;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.mods.kubejs.recipe.minecraft.CookingRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.SmithingRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.StonecuttingRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauEnchantingApparatusRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauEnchantmentRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ArsNouveauGlyphPressRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.BotaniaRunicAltarRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.BotanyPotsCropRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.IDSqueezerRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.MATagRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ShapedArtisanRecipeJS;
import dev.latvian.mods.kubejs.recipe.mod.ShapelessArtisanRecipeJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.CustomJavaToJsWrappersEvent;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ClassFilter;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.NBTIOWrapper;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.CollectionTagWrapper;
import dev.latvian.mods.rhino.mod.util.CompoundTagWrapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.wrapper.AABBWrapper;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.mod.wrapper.DirectionWrapper;
import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import dev.latvian.mods.unit.Unit;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_101;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2741;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3825;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5658;
import net.minecraft.class_6017;

public class BuiltinKubeJSPlugin
extends KubeJSPlugin {
    public static final HashMap<String, Object> GLOBAL = new HashMap();

    @Override
    public void init() {
        RegistryObjectBuilderTypes.SOUND_EVENT.addType("basic", SoundEventBuilder.class, SoundEventBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("basic", BasicBlockJS.Builder.class, BasicBlockJS.Builder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("detector", DetectorBlock.Builder.class, DetectorBlock.Builder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("slab", SlabBlockBuilder.class, SlabBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("stairs", StairBlockBuilder.class, StairBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("fence", FenceBlockBuilder.class, FenceBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("fence_gate", FenceGateBlockBuilder.class, FenceGateBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("wall", WallBlockBuilder.class, WallBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("wooden_pressure_plate", WoodenPressurePlateBlockBuilder.class, WoodenPressurePlateBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("stone_pressure_plate", StonePressurePlateBlockBuilder.class, StonePressurePlateBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("wooden_button", WoodenButtonBlockBuilder.class, WoodenButtonBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("stone_button", StoneButtonBlockBuilder.class, StoneButtonBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("falling", FallingBlockBuilder.class, FallingBlockBuilder::new);
        RegistryObjectBuilderTypes.BLOCK.addType("crop", CropBlockBuilder.class, CropBlockBuilder::new);
        RegistryObjectBuilderTypes.ITEM.addType("basic", BasicItemJS.Builder.class, BasicItemJS.Builder::new);
        RegistryObjectBuilderTypes.ITEM.addType("sword", SwordItemBuilder.class, SwordItemBuilder::new);
        RegistryObjectBuilderTypes.ITEM.addType("pickaxe", PickaxeItemBuilder.class, PickaxeItemBuilder::new);
        RegistryObjectBuilderTypes.ITEM.addType("axe", AxeItemBuilder.class, AxeItemBuilder::new);
        RegistryObjectBuilderTypes.ITEM.addType("shovel", ShovelItemBuilder.class, ShovelItemBuilder::new);
        RegistryObjectBuilderTypes.ITEM.addType("hoe", HoeItemBuilder.class, HoeItemBuilder::new);
        RegistryObjectBuilderTypes.ITEM.addType("helmet", ArmorItemBuilder.Helmet.class, ArmorItemBuilder.Helmet::new);
        RegistryObjectBuilderTypes.ITEM.addType("chestplate", ArmorItemBuilder.Chestplate.class, ArmorItemBuilder.Chestplate::new);
        RegistryObjectBuilderTypes.ITEM.addType("leggings", ArmorItemBuilder.Leggings.class, ArmorItemBuilder.Leggings::new);
        RegistryObjectBuilderTypes.ITEM.addType("boots", ArmorItemBuilder.Boots.class, ArmorItemBuilder.Boots::new);
        RegistryObjectBuilderTypes.ITEM.addType("music_disc", RecordItemJS.Builder.class, RecordItemJS.Builder::new);
        RegistryObjectBuilderTypes.FLUID.addType("basic", FluidBuilder.class, FluidBuilder::new);
        RegistryObjectBuilderTypes.ENCHANTMENT.addType("basic", EnchantmentBuilder.class, EnchantmentBuilder::new);
        RegistryObjectBuilderTypes.MOB_EFFECT.addType("basic", BasicMobEffect.Builder.class, BasicMobEffect.Builder::new);
        RegistryObjectBuilderTypes.POTION.addType("basic", PotionBuilder.class, PotionBuilder::new);
        RegistryObjectBuilderTypes.PARTICLE_TYPE.addType("basic", ParticleTypeBuilder.class, ParticleTypeBuilder::new);
        RegistryObjectBuilderTypes.MOTIVE.addType("basic", MotiveBuilder.class, MotiveBuilder::new);
        RegistryObjectBuilderTypes.CUSTOM_STAT.addType("basic", CustomStatBuilder.class, CustomStatBuilder::new);
        RegistryObjectBuilderTypes.POINT_OF_INTEREST_TYPE.addType("basic", PoiTypeBuilder.class, PoiTypeBuilder::new);
        RegistryObjectBuilderTypes.VILLAGER_TYPE.addType("basic", VillagerTypeBuilder.class, VillagerTypeBuilder::new);
        RegistryObjectBuilderTypes.VILLAGER_PROFESSION.addType("basic", VillagerProfessionBuilder.class, VillagerProfessionBuilder::new);
    }

    @Override
    public void initStartup() {
        new ItemToolTierEventJS().post("item.registry.tool_tiers");
        new ItemArmorTierEventJS().post("item.registry.armor_tiers");
        for (RegistryObjectBuilderTypes<?> types : RegistryObjectBuilderTypes.MAP.values()) {
            types.postEvent("%s.registry".formatted(UtilsJS.stripIdForEvent(types.registryKey.method_29177())));
            if (!types.registryKey.method_29177().method_12836().equals("minecraft")) continue;
            types.postEvent("%s.registry".formatted(UtilsJS.stripEventName(types.registryKey.method_29177().method_12832())));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientInit() {
        Painter.INSTANCE.registerObject("screen_group", ScreenGroup::new);
        Painter.INSTANCE.registerObject("rectangle", RectangleObject::new);
        Painter.INSTANCE.registerObject("text", TextObject::new);
        Painter.INSTANCE.registerObject("atlas_texture", AtlasTextureObject::new);
        Painter.INSTANCE.registerObject("gradient", GradientObject::new);
        Painter.INSTANCE.registerObject("item", ItemObject::new);
    }

    @Override
    public void addClasses(ScriptType type, ClassFilter filter) {
        filter.allow("java.lang.Number");
        filter.allow("java.lang.String");
        filter.allow("java.lang.Character");
        filter.allow("java.lang.Byte");
        filter.allow("java.lang.Short");
        filter.allow("java.lang.Integer");
        filter.allow("java.lang.Long");
        filter.allow("java.lang.Float");
        filter.allow("java.lang.Double");
        filter.allow("java.lang.Boolean");
        filter.allow("java.lang.Runnable");
        filter.allow("java.lang.Iterable");
        filter.allow("java.lang.Comparable");
        filter.allow("java.lang.CharSequence");
        filter.allow("java.math.BigInteger");
        filter.allow("java.math.BigDecimal");
        filter.deny("java.io");
        filter.allow("java.io.Closeable");
        filter.allow("java.io.Serializable");
        filter.deny("java.nio");
        filter.allow("java.nio.ByteOrder");
        filter.allow("java.util");
        filter.deny("java.util.jar");
        filter.deny("java.util.zip");
        filter.allow("it.unimi.dsi.fastutil");
        filter.allow("dev.latvian.mods.kubejs");
        filter.deny("dev.latvian.mods.kubejs.script");
        filter.deny("dev.latvian.mods.kubejs.mixin");
        filter.deny(KubeJSPlugin.class);
        filter.deny(KubeJSPlugins.class);
        filter.allow("net.minecraft");
        filter.allow("com.mojang.authlib.GameProfile");
        filter.allow("com.mojang.util.UUIDTypeAdapter");
        filter.allow("com.mojang.brigadier");
        filter.allow("com.mojang.blaze3d");
        filter.allow("dev.architectury");
        filter.deny("java.net");
        filter.deny("sun");
        filter.deny("com.sun");
        filter.deny("io.netty");
        filter.deny("org.objectweb.asm");
        filter.deny("org.spongepowered.asm");
        filter.deny("org.openjdk.nashorn");
        filter.deny("jdk.nashorn");
        filter.allow("mezz.jei");
    }

    @Override
    public void addBindings(BindingsEvent event) {
        event.add("global", GLOBAL);
        if (event.type == ScriptType.SERVER) {
            ServerSettings.instance = new ServerSettings();
            event.add("settings", ServerSettings.instance);
        }
        event.add("Platform", PlatformWrapper.class);
        event.add("console", event.type.console);
        event.addFunction("onEvent", args -> BuiltinKubeJSPlugin.onEvent(event, args), null, IEventHandler.class);
        event.addFunction("postEvent", args -> BuiltinKubeJSPlugin.postEvent(event, args), String.class, Object.class, Boolean.class);
        event.addFunction("java", args -> event.manager.loadJavaClass(event, args), new Class[]{null});
        event.add("JavaMath", Math.class);
        event.add("ResourceLocation", class_2960.class);
        event.add("Utils", UtilsWrapper.class);
        event.add("Component", ComponentWrapper.class);
        event.add("Text", ComponentWrapper.class);
        event.add("UUID", UUIDWrapper.class);
        event.add("JsonIO", JsonIO.class);
        event.add("Block", BlockWrapper.class);
        event.add("Item", ItemWrapper.class);
        event.add("Ingredient", IngredientWrapper.class);
        event.add("NBT", NBTUtils.class);
        event.add("NBTIO", NBTIOWrapper.class);
        event.add("Direction", DirectionWrapper.class);
        event.add("Facing", DirectionWrapper.class);
        event.add("AABB", AABBWrapper.class);
        event.add("Fluid", FluidWrapper.class);
        event.add("SECOND", 1000L);
        event.add("MINUTE", 60000L);
        event.add("HOUR", 3600000L);
        event.add("Color", ColorWrapper.class);
        event.add("BlockStatePredicate", BlockStatePredicate.class);
        event.add("EquipmentSlot", class_1304.class);
        event.add("SLOT_MAINHAND", class_1304.field_6173);
        event.add("SLOT_OFFHAND", class_1304.field_6171);
        event.add("SLOT_FEET", class_1304.field_6166);
        event.add("SLOT_LEGS", class_1304.field_6172);
        event.add("SLOT_CHEST", class_1304.field_6174);
        event.add("SLOT_HEAD", class_1304.field_6169);
        event.add("Rarity", class_1814.class);
        event.add("RARITY_COMMON", class_1814.field_8906);
        event.add("RARITY_UNCOMMON", class_1814.field_8907);
        event.add("RARITY_RARE", class_1814.field_8903);
        event.add("RARITY_EPIC", class_1814.field_8904);
        event.add("AIR_ITEM", class_1802.field_8162);
        event.add("AIR_BLOCK", class_2246.field_10124);
        event.add("Hand", class_1268.class);
        event.add("MAIN_HAND", class_1268.field_5808);
        event.add("OFF_HAND", class_1268.field_5810);
        event.add("DecorationGenerationStep", class_2893.class_2895.class);
        event.add("CarvingGenerationStep", class_2893.class_2894.class);
        event.add("Vec3", class_243.class);
        event.add("Vec3d", class_243.class);
        event.add("Vec3i", class_2382.class);
        event.add("BlockPos", class_2338.class);
        event.add("BlockProperties", class_2741.class);
        KubeJS.PROXY.clientBindings(event);
    }

    private static Object onEvent(BindingsEvent event, Object[] args) {
        for (Object o : ListJS.orSelf(args[0])) {
            event.type.manager.get().events.listen(String.valueOf(o), (IEventHandler)args[1]);
        }
        return null;
    }

    private static Object postEvent(BindingsEvent event, Object[] args) {
        String id = String.valueOf(args[0]);
        Object data = args.length >= 2 ? args[1] : null;
        boolean cancellable = args.length >= 3 && Boolean.TRUE.equals(args[2]);
        EventsJS events = event.type.manager.get().events;
        return events.postToHandlers(id, events.handlers(id), new DataEvent(cancellable, data));
    }

    @Override
    public void addTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.register(String.class, String::valueOf);
        typeWrappers.register(CharSequence.class, String::valueOf);
        typeWrappers.register(UUID.class, UUIDWrapper::fromString);
        typeWrappers.register(Pattern.class, UtilsJS::parseRegex);
        typeWrappers.register(JsonObject.class, MapJS::json);
        typeWrappers.register(JsonArray.class, ListJS::json);
        typeWrappers.register(JsonElement.class, JsonIO::of);
        typeWrappers.register(JsonPrimitive.class, JsonIO::primitiveOf);
        typeWrappers.register(Path.class, UtilsJS::getPath);
        typeWrappers.register(File.class, UtilsJS::getFileFromPath);
        typeWrappers.register(Unit.class, Painter.INSTANCE::unitOf);
        typeWrappers.register(class_2960.class, UtilsJS::getMCID);
        typeWrappers.register(class_1799.class, o -> ItemStackJS.of(o).getItemStack());
        typeWrappers.register(class_2487.class, NBTUtils::isTagCompound, NBTUtils::toTagCompound);
        typeWrappers.register(class_2483.class, NBTUtils::isTagCollection, NBTUtils::toTagCollection);
        typeWrappers.register(class_2499.class, NBTUtils::isTagCollection, NBTUtils::toTagList);
        typeWrappers.register(class_2520.class, NBTUtils::toTag);
        typeWrappers.register(class_2338.class, UtilsJS::blockPosOf);
        typeWrappers.register(class_243.class, UtilsJS::vec3Of);
        typeWrappers.register(class_1792.class, ItemStackJS::getRawItem);
        typeWrappers.register(class_1311.class, o -> o == null ? null : class_1311.method_28307((String)o.toString()));
        typeWrappers.register(class_238.class, AABBWrapper::wrap);
        typeWrappers.register(class_6017.class, UtilsJS::intProviderOf);
        typeWrappers.register(class_5658.class, UtilsJS::numberProviderOf);
        typeWrappers.register(class_47.class_50.class, o -> o == null ? null : class_47.class_50.method_314((String)o.toString().toLowerCase()));
        typeWrappers.register(class_101.class_102.class, o -> o == null ? null : class_101.class_102.method_475((String)o.toString().toLowerCase()));
        typeWrappers.register(MapJS.class, MapJS::of);
        typeWrappers.register(ListJS.class, ListJS::of);
        typeWrappers.register(ItemStackJS.class, ItemStackJS::of);
        typeWrappers.register(IngredientJS.class, IngredientJS::of);
        typeWrappers.register(IngredientStackJS.class, o -> IngredientJS.of(o).asIngredientStack());
        typeWrappers.register(BlockStatePredicate.class, BlockStatePredicate::of);
        typeWrappers.register(class_3825.class, BlockStatePredicate::ruleTestOf);
        typeWrappers.register(BiomeFilter.class, BiomeFilter::of);
        typeWrappers.register(MobFilter.class, MobFilter::of);
        typeWrappers.register(FluidStackJS.class, FluidStackJS::of);
        typeWrappers.register(RecipeFilter.class, RecipeFilter::of);
        typeWrappers.register(MaterialJS.class, MaterialListJS.INSTANCE::of);
        typeWrappers.register(IngredientActionFilter.class, IngredientActionFilter::filterOf);
        typeWrappers.register(class_1832.class, o -> ItemBuilder.TOOL_TIERS.getOrDefault(String.valueOf(o), (class_1832)class_1834.field_8923));
        typeWrappers.register(class_1741.class, ItemBuilder::ofArmorMaterial);
        typeWrappers.register(PlayerSelector.class, PlayerSelector::of);
        typeWrappers.register(class_2561.class, ComponentWrapper::of);
        typeWrappers.register(class_5250.class, o -> new class_2585("").method_10852((class_2561)ComponentWrapper.of(o)));
        typeWrappers.register(Color.class, ColorWrapper::of);
        typeWrappers.register(class_5251.class, o -> ColorWrapper.of((Object)o).createTextColorJS());
        typeWrappers.register(class_2558.class, ComponentWrapper::clickEventOf);
        KubeJS.PROXY.clientTypeWrappers(typeWrappers);
    }

    @Override
    public void addCustomJavaToJsWrappers(CustomJavaToJsWrappersEvent event) {
        event.add(class_2487.class, CompoundTagWrapper::new);
        event.add(class_2483.class, CollectionTagWrapper::new);
    }

    @Override
    public void addRecipes(RegisterRecipeHandlersEvent event) {
        event.registerShaped(new class_2960("kubejs:shaped"));
        event.registerShapeless(new class_2960("kubejs:shapeless"));
        event.registerShaped(new class_2960("minecraft:crafting_shaped"));
        event.registerShapeless(new class_2960("minecraft:crafting_shapeless"));
        event.register(new class_2960("minecraft:stonecutting"), StonecuttingRecipeJS::new);
        event.register(new class_2960("minecraft:smelting"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:blasting"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:smoking"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:campfire_cooking"), CookingRecipeJS::new);
        event.register(new class_2960("minecraft:smithing"), SmithingRecipeJS::new);
        if (Platform.isModLoaded((String)"cucumber")) {
            event.registerShaped(new class_2960("cucumber:shaped_no_mirror"));
        }
        if (Platform.isModLoaded((String)"mysticalagriculture")) {
            event.register(new class_2960("mysticalagriculture:tag"), MATagRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"botanypots")) {
            event.register(new class_2960("botanypots:crop"), BotanyPotsCropRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"extendedcrafting")) {
            event.registerShaped(new class_2960("extendedcrafting:shaped_table"));
            event.registerShapeless(new class_2960("extendedcrafting:shapeless_table"));
        }
        if (Platform.isModLoaded((String)"dankstorage")) {
            event.registerShaped(new class_2960("dankstorage:upgrade"));
        }
        if (Platform.isModLoaded((String)"artisanworktables")) {
            String[] types;
            for (String t : types = new String[]{"basic", "blacksmith", "carpenter", "chef", "chemist", "designer", "engineer", "farmer", "jeweler", "mage", "mason", "potter", "scribe", "tailor", "tanner"}) {
                event.register(new class_2960("artisanworktables:" + t + "_shaped"), ShapedArtisanRecipeJS::new);
                event.register(new class_2960("artisanworktables:" + t + "_shapeless"), ShapelessArtisanRecipeJS::new);
            }
        }
        if (Platform.isModLoaded((String)"botania")) {
            event.register(new class_2960("botania:runic_altar"), BotaniaRunicAltarRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"integrateddynamics") && !Platform.isModLoaded((String)"kubejs_integrated_dynamics")) {
            event.register(new class_2960("integrateddynamics:squeezer"), IDSqueezerRecipeJS::new);
            event.register(new class_2960("integrateddynamics:mechanical_squeezer"), IDSqueezerRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"ars_nouveau")) {
            event.register(new class_2960("ars_nouveau:enchanting_apparatus"), ArsNouveauEnchantingApparatusRecipeJS::new);
            event.register(new class_2960("ars_nouveau:enchantment"), ArsNouveauEnchantmentRecipeJS::new);
            event.register(new class_2960("ars_nouveau:glyph_recipe"), ArsNouveauGlyphPressRecipeJS::new);
        }
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
        for (BuilderBase<?> builder : RegistryObjectBuilderTypes.ALL_BUILDERS) {
            builder.generateDataJsons(generator);
        }
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        for (BuilderBase<?> builder : RegistryObjectBuilderTypes.ALL_BUILDERS) {
            builder.generateAssetJsons(generator);
        }
    }

    @Override
    public void generateLang(Map<String, String> lang) {
        lang.put("itemGroup.kubejs.kubejs", "KubeJS");
        lang.put("item.kubejs.dummy_fluid_item", "Dummy Fluid Item");
        for (BuilderBase<?> builder : RegistryObjectBuilderTypes.ALL_BUILDERS) {
            builder.generateLang(lang);
        }
    }
}

