/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import dev.architectury.registry.registries.DeferredRegister;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class RegistryObjectBuilderTypes<T> {
    public static final Map<class_5321<?>, RegistryObjectBuilderTypes<?>> MAP = new LinkedHashMap();
    public static final List<BuilderBase<?>> ALL_BUILDERS = new ArrayList();
    public static final RegistryObjectBuilderTypes<class_3414> SOUND_EVENT = RegistryObjectBuilderTypes.add(class_2378.field_25102, class_3414.class);
    public static final RegistryObjectBuilderTypes<class_3611> FLUID = RegistryObjectBuilderTypes.add(class_2378.field_25103, class_3611.class);
    public static final RegistryObjectBuilderTypes<class_2248> BLOCK = RegistryObjectBuilderTypes.add(class_2378.field_25105, class_2248.class);
    public static final RegistryObjectBuilderTypes<class_1792> ITEM = RegistryObjectBuilderTypes.add(class_2378.field_25108, class_1792.class);
    public static final RegistryObjectBuilderTypes<class_1887> ENCHANTMENT = RegistryObjectBuilderTypes.add(class_2378.field_25106, class_1887.class);
    public static final RegistryObjectBuilderTypes<class_1291> MOB_EFFECT = RegistryObjectBuilderTypes.add(class_2378.field_25104, class_1291.class);
    public static final RegistryObjectBuilderTypes<class_1299<?>> ENTITY_TYPE = RegistryObjectBuilderTypes.add(class_2378.field_25107, class_1299.class);
    public static final RegistryObjectBuilderTypes<class_2591<?>> BLOCK_ENTITY_TYPE = RegistryObjectBuilderTypes.add(class_2378.field_25073, class_2591.class);
    public static final RegistryObjectBuilderTypes<class_1842> POTION = RegistryObjectBuilderTypes.add(class_2378.field_25109, class_1842.class);
    public static final RegistryObjectBuilderTypes<class_2396<?>> PARTICLE_TYPE = RegistryObjectBuilderTypes.add(class_2378.field_25070, class_2396.class);
    public static final RegistryObjectBuilderTypes<class_1535> MOTIVE = RegistryObjectBuilderTypes.add(class_2378.field_25074, class_1535.class);
    public static final RegistryObjectBuilderTypes<class_2960> CUSTOM_STAT = RegistryObjectBuilderTypes.add(class_2378.field_25075, class_2960.class);
    public static final RegistryObjectBuilderTypes<class_4158> POINT_OF_INTEREST_TYPE = RegistryObjectBuilderTypes.add(class_2378.field_25090, class_4158.class);
    public static final RegistryObjectBuilderTypes<class_3854> VILLAGER_TYPE = RegistryObjectBuilderTypes.add(class_2378.field_25088, class_3854.class);
    public static final RegistryObjectBuilderTypes<class_3852> VILLAGER_PROFESSION = RegistryObjectBuilderTypes.add(class_2378.field_25089, class_3852.class);
    public final class_5321<class_2378<T>> registryKey;
    public final Class<T> objectBaseClass;
    public final DeferredRegister<T> deferredRegister;
    public final Map<String, BuilderType<T>> types;
    public final Map<class_2960, BuilderBase<? extends T>> objects;
    private BuilderType<T> defaultType;
    public BuilderBase<? extends T> current;
    public boolean bypassServerOnly;

    public static <T> RegistryObjectBuilderTypes<T> add(class_5321<class_2378<T>> key, Class<?> baseClass) {
        RegistryObjectBuilderTypes<T> types = new RegistryObjectBuilderTypes<T>(key, (Class)UtilsJS.cast(baseClass));
        if (MAP.put(key, types) != null) {
            throw new IllegalStateException("Registry with id '" + key + "' already exists!");
        }
        return types;
    }

    private RegistryObjectBuilderTypes(class_5321<class_2378<T>> key, Class<T> baseClass) {
        this.registryKey = key;
        this.objectBaseClass = baseClass;
        this.deferredRegister = DeferredRegister.create((String)"kubejs", this.registryKey);
        this.types = new LinkedHashMap<String, BuilderType<T>>();
        this.objects = new LinkedHashMap<class_2960, BuilderBase<? extends T>>();
        this.current = null;
        this.bypassServerOnly = false;
    }

    public RegistryObjectBuilderTypes<T> bypassServerOnly() {
        this.bypassServerOnly = true;
        return this;
    }

    public void addType(String type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory<T> factory, boolean isDefault) {
        BuilderType<T> b = new BuilderType<T>(type, builderType, factory);
        this.types.put(type, b);
        if (isDefault) {
            if (this.defaultType != null) {
                ConsoleJS.STARTUP.warn("Previous default type '" + this.defaultType.type + "' for registry '" + this.registryKey.method_29177() + "' replaced with '" + type + "'!");
            }
            this.defaultType = b;
        }
    }

    public void addType(String type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory<T> factory) {
        this.addType(type, builderType, factory, type.equals("basic"));
    }

    public void addBuilder(BuilderBase<? extends T> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + this.registryKey.method_29177() + "'!");
        }
        if (CommonProperties.get().debugInfo) {
            ConsoleJS.STARTUP.setLineNumber(true);
            ConsoleJS.STARTUP.info("~ " + this.registryKey.method_29177() + " | " + builder.id);
            ConsoleJS.STARTUP.setLineNumber(false);
        }
        if (this.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + builder.id + "' in registry '" + this.registryKey.method_29177() + "'!");
        }
        this.objects.put(builder.id, builder);
        ALL_BUILDERS.add(builder);
    }

    @Nullable
    public BuilderType<T> getDefaultType() {
        if (this.types.isEmpty()) {
            return null;
        }
        if (this.defaultType == null) {
            this.defaultType = this.types.values().iterator().next();
        }
        return this.defaultType;
    }

    void postEvent(String id) {
        if (!this.types.isEmpty()) {
            new RegistryEventJS(this).post(id);
        }
    }

    static void registerAll(boolean all) {
        for (BuilderBase<?> builderBase : new ArrayList(ALL_BUILDERS)) {
            builderBase.createAdditionalObjects();
        }
        for (RegistryObjectBuilderTypes registryObjectBuilderTypes : MAP.values()) {
            boolean any = false;
            for (BuilderBase builder : registryObjectBuilderTypes.objects.values()) {
                if (!builder.registerObject(all)) continue;
                any = true;
            }
            if (!any) continue;
            registryObjectBuilderTypes.deferredRegister.register();
        }
    }

    @Nullable
    public BuilderBase<? extends T> getCurrent() {
        return this.current;
    }

    public record BuilderType<T>(String type, Class<? extends BuilderBase<? extends T>> builderClass, BuilderFactory<T> factory) {
    }

    public static interface BuilderFactory<T> {
        public BuilderBase<? extends T> createBuilder(class_2960 var1);
    }

    public static class RegistryEventJS<T>
    extends StartupEventJS {
        private final RegistryObjectBuilderTypes<T> registry;

        private RegistryEventJS(RegistryObjectBuilderTypes<T> r) {
            this.registry = r;
        }

        public BuilderBase<? extends T> create(String id, String type) {
            BuilderType t = this.registry.types.get(type);
            if (t == null) {
                throw new IllegalArgumentException("Unknown type '" + type + "' for object '" + id + "'!");
            }
            BuilderBase b = t.factory.createBuilder(UtilsJS.getMCID(KubeJS.appendModId(id)));
            if (b == null) {
                throw new IllegalArgumentException("Unknown type '" + type + "' for object '" + id + "'!");
            }
            this.registry.addBuilder(b);
            return b;
        }

        public BuilderBase<? extends T> create(String id) {
            BuilderType<T> t = this.registry.getDefaultType();
            if (t == null) {
                throw new IllegalArgumentException("Registry for type '" + this.registry.registryKey.method_29177() + "' doesn't have any builders registered!");
            }
            BuilderBase b = t.factory.createBuilder(UtilsJS.getMCID(KubeJS.appendModId(id)));
            if (b == null) {
                throw new IllegalArgumentException("Unknown type '" + t.type + "' for object '" + id + "'!");
            }
            this.registry.addBuilder(b);
            return b;
        }
    }
}

