/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.Registrar;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.util.ClassWrapper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.mod.util.CountingMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public interface UtilsWrapper {
    public static ServerJS getServer() {
        return ServerJS.instance;
    }

    public static void queueIO(Runnable runnable) {
        UtilsJS.queueIO(runnable);
    }

    public static Random getRandom() {
        return UtilsJS.RANDOM;
    }

    public static Random newRandom(long seed) {
        return new Random(seed);
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static ListJS newList() {
        return new ListJS();
    }

    public static MapJS newMap() {
        return new MapJS();
    }

    public static CountingMap newCountingMap() {
        return new CountingMap();
    }

    public static class_2960 id(String namespace, String path) {
        return new class_2960(namespace, path);
    }

    public static class_2960 id(class_2960 id) {
        return id;
    }

    public static ConsoleJS createConsole(String name) {
        return new ConsoleJS(ScriptType.getCurrent(ScriptType.STARTUP), LoggerFactory.getLogger((String)name));
    }

    public static Pattern regex(Object s) {
        Pattern pattern = UtilsJS.parseRegex(s);
        return pattern == null ? Pattern.compile(s.toString()) : pattern;
    }

    public static Pattern regex(String pattern, int flags) {
        return Pattern.compile(pattern, flags);
    }

    public static int parseInt(@Nullable Object object, int def) {
        return UtilsJS.parseInt(object, def);
    }

    public static double parseDouble(@Nullable Object object, double def) {
        return UtilsJS.parseDouble(object, def);
    }

    public static class_3445<class_2960> getStat(class_2960 id) {
        return class_3468.field_15419.method_14956((Object)id);
    }

    public static LevelJS getLevel(class_1937 level) {
        return UtilsJS.getLevel(level);
    }

    public static LevelJS getClientLevel() {
        return UtilsJS.getClientLevel();
    }

    @Nullable
    public static class_3414 getSound(class_2960 id) {
        return (class_3414)KubeJSRegistries.soundEvents().get(id);
    }

    public static Object randomOf(Random random, Collection<Object> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (objects instanceof List) {
            List list = (List)objects;
            return list.get(random.nextInt(objects.size()));
        }
        return new ArrayList<Object>(objects).get(random.nextInt(objects.size()));
    }

    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    public static ListJS rollChestLoot(class_2960 id) {
        return UtilsWrapper.rollChestLoot(id, null);
    }

    public static ListJS rollChestLoot(class_2960 id, @Nullable EntityJS entity) {
        return UtilsJS.rollChestLoot(id, entity);
    }

    @Nullable
    public static ListJS listOf(@Nullable Object o) {
        return ListJS.of(o);
    }

    public static ListJS listOrSelf(@Nullable Object o) {
        return ListJS.orSelf(o);
    }

    @Nullable
    public static MapJS mapOf(@Nullable Object o) {
        return MapJS.of(o);
    }

    @Nullable
    public static Object copy(@Nullable Object o) {
        return UtilsJS.copy(o);
    }

    public static boolean isWrapped(@Nullable Object o) {
        return o instanceof WrappedJS;
    }

    public static String toTitleCase(String s) {
        return UtilsJS.toTitleCase(s);
    }

    public static ClassWrapper<KubeJSRegistries> getRegistries() {
        return new ClassWrapper<KubeJSRegistries>(KubeJSRegistries.class);
    }

    public static Registrar<?> getRegistry(class_2960 id) {
        return Objects.requireNonNull(KubeJSRegistries.genericRegistry(class_5321.method_29180((class_2960)id)), "No builtin or static registry found for %s!".formatted(id));
    }

    public static Collection<class_2960> getRegistryIds(class_2960 id) {
        return UtilsWrapper.getRegistry(id).getIds();
    }

    public static <T> Supplier<T> lazy(Supplier<T> supplier) {
        return Suppliers.memoize(supplier::get);
    }

    public static <T> Supplier<T> expiringLazy(Supplier<T> supplier, long time) {
        return Suppliers.memoizeWithExpiration(supplier::get, (long)time, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

