/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.block.SeedItemBuilder;
import dev.latvian.mods.kubejs.block.custom.BasicCropBlockJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_44;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class CropBlockBuilder
extends BlockBuilder {
    public transient int age = 7;
    protected transient List<class_265> shapeByAge = Collections.nCopies(8, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public transient boolean dropSeed;
    public transient ToDoubleFunction<RandomTickCallbackJS> growSpeedCallback = null;
    public transient ToIntFunction<RandomTickCallbackJS> fertilizerCallback = null;
    public transient SurviveCallback surviveCallback = null;
    public transient List<Pair<Object, Double>> outputs;

    public CropBlockBuilder(class_2960 i) {
        super(i);
        this.material = MaterialListJS.INSTANCE.map.get("crop");
        this.renderType = "cutout";
        this.noCollision = true;
        this.itemBuilder = new SeedItemBuilder(this.newID("", "_seed"));
        this.itemBuilder.blockBuilder = this;
        this.hardness = 0.0f;
        this.resistance = 0.0f;
        this.dropSeed = true;
        this.outputs = new ArrayList<Pair<Object, Double>>();
        this.notSolid = true;
        this.lootTable = loot -> {
            JsonObject condition = new JsonObject();
            condition.addProperty("condition", "minecraft:block_state_property");
            condition.addProperty("block", this.newID("", "").toString());
            JsonObject properties = new JsonObject();
            properties.addProperty("age", String.valueOf(this.age));
            condition.add("properties", (JsonElement)properties);
            JsonObject function = new JsonObject();
            function.addProperty("function", "minecraft:apply_bonus");
            function.addProperty("enchantment", "minecraft:fortune");
            function.addProperty("formula", "minecraft:binomial_with_bonus_count");
            JsonObject parameters = new JsonObject();
            parameters.addProperty("extra", (Number)3);
            parameters.addProperty("probability", (Number)0.5714286);
            function.add("parameters", (JsonElement)parameters);
            if (this.dropSeed) {
                loot.addPool(bonuses -> {
                    bonuses.rolls = class_44.method_32448((float)1.0f);
                    bonuses.bonusRolls = class_44.method_32448((float)0.0f);
                    bonuses.addItem(new class_1799((class_1935)this.itemBuilder.get())).addCondition(condition).addFunction(function);
                    bonuses.addItem(new class_1799((class_1935)this.itemBuilder.get()));
                });
            }
            for (Pair<Object, Double> output : this.outputs) {
                loot.addPool(crops -> {
                    crops.rolls = class_44.method_32448((float)1.0f);
                    crops.bonusRolls = class_44.method_32448((float)0.0f);
                    crops.addItem(ItemStackJS.of(output.getFirst()).getItemStack()).addCondition(condition).randomChance((Double)output.getSecond());
                });
            }
        };
        for (int a = 0; a <= this.age; ++a) {
            this.texture(String.valueOf(a), this.id.method_12836() + ":block/" + this.id.method_12832() + a);
        }
        this.tagBlock(class_3481.field_20341.comp_327());
        if (Platform.isForge()) {
            this.tagItem(new class_2960("forge", "seeds"));
        }
    }

    public CropBlockBuilder crop(Object output) {
        this.crop(output, 1.0);
        return this;
    }

    public CropBlockBuilder crop(Object output, double chance) {
        this.outputs.add((Pair<Object, Double>)new Pair(output, (Object)chance));
        return this;
    }

    public CropBlockBuilder age(int age) {
        this.age(age, builder -> {});
        return this;
    }

    public CropBlockBuilder dropSeed(boolean dropSeed) {
        this.dropSeed = dropSeed;
        return this;
    }

    public CropBlockBuilder age(int age, Consumer<ShapeBuilder> builder) {
        this.age = age;
        ShapeBuilder shapes = new ShapeBuilder(age);
        builder.accept(shapes);
        this.shapeByAge = shapes.getShapes();
        for (int i = 0; i <= age; ++i) {
            this.texture(String.valueOf(i), this.id.method_12836() + ":block/" + this.id.method_12832() + i);
        }
        return this;
    }

    @Override
    public BlockBuilder texture(String id, String tex) {
        try {
            int intId = (int)Double.parseDouble(id);
            return super.texture(String.valueOf(intId), tex);
        }
        catch (NumberFormatException e) {
            return super.texture(id, tex);
        }
    }

    public CropBlockBuilder bonemeal(ToIntFunction<RandomTickCallbackJS> bonemealCallback) {
        this.fertilizerCallback = bonemealCallback;
        return this;
    }

    public CropBlockBuilder survive(SurviveCallback surviveCallback) {
        this.surviveCallback = surviveCallback;
        return this;
    }

    public CropBlockBuilder growTick(ToDoubleFunction<RandomTickCallbackJS> growSpeedCallback) {
        this.growSpeedCallback = growSpeedCallback;
        return this;
    }

    @Override
    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        KubeJS.LOGGER.warn("randomTick is overridden by growTick to return grow speed, use it instead.");
        return this;
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.blockstateJson != null) {
            generator.json(this.newID("blockstates/", ""), (JsonElement)this.blockstateJson);
        } else {
            generator.blockState(this.id, bs -> {
                for (int i = 0; i <= this.age; ++i) {
                    bs.variant("age=%s".formatted(i), (String)(this.model.isEmpty() ? this.id.method_12836() + ":block/" + this.id.method_12832() + i : this.model));
                }
            });
        }
        if (this.modelJson != null) {
            generator.json(this.newID("models/block/", ""), (JsonElement)this.modelJson);
        } else {
            for (int i = 0; i <= this.age; ++i) {
                int fi = i;
                generator.blockModel(this.newID("", String.valueOf(i)), m -> {
                    m.parent("minecraft:block/crop");
                    m.texture("crop", this.textures.get(String.valueOf(fi)).getAsString());
                });
            }
        }
        if (this.itemBuilder != null) {
            this.itemBuilder.generateAssetJsons(generator);
        }
    }

    @Override
    public class_2248 createObject() {
        final class_2758 ageProperty = class_2758.method_11867((String)"age", (int)0, (int)this.age);
        return new BasicCropBlockJS(this){

            public class_2758 method_9824() {
                return ageProperty;
            }
        };
    }

    @FunctionalInterface
    public static interface SurviveCallback {
        public boolean survive(class_2680 var1, class_4538 var2, class_2338 var3);
    }

    public static class ShapeBuilder {
        private final List<class_265> shapes;

        public ShapeBuilder(int age) {
            this.shapes = new ArrayList<class_265>(Collections.nCopies(age + 1, class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));
        }

        public ShapeBuilder shape(int age, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.shapes.set(age, class_2248.method_9541((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
            return this;
        }

        public List<class_265> getShapes() {
            return List.copyOf(this.shapes);
        }
    }
}

