/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTextureStitchEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.fluid.FluidBucketHooks;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.client.ClientLoggedInEventJS;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.ClientTickEventJS;
import dev.latvian.mods.kubejs.client.DebugInfoEventJS;
import dev.latvian.mods.kubejs.client.TagInstance;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.core.ImageButtonKJS;
import dev.latvian.mods.kubejs.item.ItemModelPropertiesEventJS;
import dev.latvian.mods.kubejs.item.ItemTooltipEventJS;
import dev.latvian.mods.kubejs.level.ClientLevelJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.Tags;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.class_1059;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_518;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class KubeJSClientEventHandler {
    private static final class_2960 RECIPE_BUTTON_TEXTURE = new class_2960("textures/gui/recipe_button.png");
    public static Map<class_1792, List<ItemTooltipEventJS.StaticTooltipHandler>> staticItemTooltips = null;
    private final Map<class_2960, TagInstance> tempTagNames = new LinkedHashMap<class_2960, TagInstance>();

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::clientSetup);
        ClientGuiEvent.DEBUG_TEXT_LEFT.register(this::debugInfoLeft);
        ClientGuiEvent.DEBUG_TEXT_RIGHT.register(this::debugInfoRight);
        ClientTooltipEvent.ITEM.register(this::itemTooltip);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::loggedIn);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register(this::respawn);
        ClientGuiEvent.RENDER_HUD.register(Painter.INSTANCE::inGameScreenDraw);
        ClientGuiEvent.RENDER_POST.register(Painter.INSTANCE::guiScreenDraw);
        ClientGuiEvent.INIT_POST.register(this::guiPostInit);
        ClientTextureStitchEvent.POST.register(this::postAtlasStitch);
    }

    private void clientSetup(class_310 minecraft) {
        for (BuilderBase<?> builder : RegistryObjectBuilderTypes.ALL_BUILDERS) {
            builder.clientRegistry(() -> minecraft);
        }
        new ItemModelPropertiesEventJS().post("item.model_properties");
    }

    private void debugInfoLeft(List<String> lines) {
        if (class_310.method_1551().field_1724 != null) {
            new DebugInfoEventJS(lines).post(ScriptType.CLIENT, "client.debug_info.left");
        }
    }

    private void debugInfoRight(List<String> lines) {
        if (class_310.method_1551().field_1724 != null) {
            new DebugInfoEventJS(lines).post(ScriptType.CLIENT, "client.debug_info.right");
        }
    }

    private void itemTooltip(class_1799 stack, List<class_2561> lines, class_1836 flag) {
        boolean advanced = flag.method_8035();
        if (advanced && ClientProperties.get().getShowTagNames() && class_437.method_25442()) {
            class_1755 bucket;
            class_1792 fluid;
            Object item;
            Consumer<class_6862> addToTempTags = tag -> this.tempTagNames.computeIfAbsent((class_2960)tag.comp_327(), (Function<class_2960, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.class_2960 ), (Lnet/minecraft/class_2960;)Ldev/latvian/mods/kubejs/client/TagInstance;)()).registries.add(tag.comp_326());
            Tags.byItemStack(stack).forEach(addToTempTags);
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                item = (class_1747)class_17922;
                Tags.byBlock(item.method_7711()).forEach(addToTempTags);
            }
            if ((class_17922 = stack.method_7909()) instanceof class_1755 && (fluid = FluidBucketHooks.getFluid((class_1755)(bucket = (class_1755)class_17922))) != class_3612.field_15906) {
                Tags.byFluid((class_3611)fluid).forEach(addToTempTags);
            }
            if ((fluid = stack.method_7909()) instanceof class_1826) {
                item = (class_1826)fluid;
                Tags.byEntityType(item.method_8015(stack.method_7969())).forEach(addToTempTags);
            }
            for (TagInstance instance : this.tempTagNames.values()) {
                lines.add(instance.toText());
            }
            this.tempTagNames.clear();
        }
        if (staticItemTooltips == null) {
            staticItemTooltips = new HashMap<class_1792, List<ItemTooltipEventJS.StaticTooltipHandler>>();
            new ItemTooltipEventJS(staticItemTooltips).post(ScriptType.CLIENT, "item.tooltip");
        }
        for (ItemTooltipEventJS.StaticTooltipHandler handler : staticItemTooltips.getOrDefault(class_1802.field_8162, Collections.emptyList())) {
            handler.tooltip(stack, advanced, lines);
        }
        for (ItemTooltipEventJS.StaticTooltipHandler handler : staticItemTooltips.getOrDefault(stack.method_7909(), Collections.emptyList())) {
            handler.tooltip(stack, advanced, lines);
        }
    }

    private void clientTick(class_310 minecraft) {
        if (class_310.method_1551().field_1724 != null && ClientLevelJS.getInstance() != null) {
            new ClientTickEventJS().post("client.tick");
        }
    }

    private void loggedIn(class_746 player) {
        ClientLevelJS.setInstance(new ClientLevelJS(class_310.method_1551(), player));
        AttachDataEvent.forLevel(ClientLevelJS.getInstance()).invoke();
        AttachDataEvent.forPlayer(ClientLevelJS.getInstance().clientPlayerData).invoke();
        new ClientLoggedInEventJS().post("client.logged_in");
    }

    private void loggedOut(class_746 player) {
        if (ClientLevelJS.getInstance() != null) {
            new ClientLoggedInEventJS().post("client.logged_out");
        }
        ClientLevelJS.setInstance(null);
        Painter.INSTANCE.clear();
    }

    private void respawn(class_746 oldPlayer, class_746 newPlayer) {
        ClientLevelJS.setInstance(new ClientLevelJS(class_310.method_1551(), newPlayer));
        AttachDataEvent.forLevel(ClientLevelJS.getInstance()).invoke();
        AttachDataEvent.forPlayer(ClientLevelJS.getInstance().clientPlayerData).invoke();
    }

    private void guiPostInit(class_437 screen, ScreenAccess access) {
        if (ClientProperties.get().getDisableRecipeBook() && screen instanceof class_518) {
            Iterator iterator = screen.method_25396().iterator();
            while (iterator.hasNext()) {
                ImageButtonKJS buttonKJS;
                class_364 listener = (class_364)iterator.next();
                if (!(listener instanceof class_339) || !(listener instanceof ImageButtonKJS) || !RECIPE_BUTTON_TEXTURE.equals((Object)(buttonKJS = (ImageButtonKJS)listener).getButtonTextureKJS())) continue;
                access.getRenderables().remove(listener);
                access.getNarratables().remove(listener);
                iterator.remove();
                return;
            }
        }
    }

    private void postAtlasStitch(class_1059 atlas) {
        if (!ClientProperties.get().getExportAtlases()) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)atlas.method_4624());
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        int[] pixels = new int[w * h];
        IntBuffer result = BufferUtils.createIntBuffer((int)(w * h));
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)result);
        result.get(pixels);
        image.setRGB(0, 0, w, h, pixels, 0, w);
        Path path = KubeJSPaths.EXPORTED.resolve(atlas.method_24106().method_12836() + "/" + atlas.method_24106().method_12832());
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
            ImageIO.write((RenderedImage)image, "PNG", stream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

