/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter.screen;

import dev.latvian.mods.kubejs.bindings.ComponentWrapper;
import dev.latvian.mods.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPaintEventJS;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.unit.FixedBooleanUnit;
import dev.latvian.mods.unit.FixedColorUnit;
import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5481;

public class TextObject
extends ScreenPainterObject {
    private class_5481[] text = new class_5481[0];
    private Unit shadow = FixedBooleanUnit.FALSE;
    private Unit scale = FixedNumberUnit.ONE;
    private Unit color = FixedColorUnit.WHITE;
    private Unit centered = FixedBooleanUnit.FALSE;
    private Unit lineSpacing = FixedNumberUnit.TEN;
    private float[] textWidth = new float[0];

    @Override
    protected void load(PainterObjectProperties properties) {
        super.load(properties);
        class_2520 class_25202 = properties.tag.method_10580("textLines");
        if (class_25202 instanceof class_2499) {
            class_2499 list = (class_2499)class_25202;
            this.text = new class_5481[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.text[i] = ComponentWrapper.of(list.method_10534(i)).method_30937();
            }
        } else {
            this.text = new class_5481[]{ComponentWrapper.of(properties.tag.method_10580("text")).method_30937()};
        }
        this.shadow = properties.getUnit("shadow", this.shadow);
        this.scale = properties.getUnit("scale", this.scale);
        this.color = properties.getColor("color", this.color);
        this.centered = properties.getUnit("centered", this.centered);
        this.lineSpacing = properties.getUnit("lineSpacing", this.lineSpacing);
        this.textWidth = new float[this.text.length];
    }

    @Override
    public void preDraw(ScreenPaintEventJS event) {
        float maxTextWidth = 0.0f;
        for (int i = 0; i < this.text.length; ++i) {
            this.textWidth[i] = event.font.method_27527().method_30875(this.text[i]);
            maxTextWidth = Math.max(maxTextWidth, this.textWidth[i]);
        }
        this.w = this.scale.mul((Unit)FixedNumberUnit.of((double)maxTextWidth));
        this.h = this.scale.mul(this.lineSpacing).mul((Unit)FixedNumberUnit.of((double)this.text.length));
    }

    @Override
    public void draw(ScreenPaintEventJS event) {
        float ls = this.lineSpacing.getFloat((UnitVariables)event);
        float ax = event.alignX(this.x.getFloat((UnitVariables)event), this.w.getFloat((UnitVariables)event), this.alignX);
        float ay = event.alignY(this.y.getFloat((UnitVariables)event), this.h.getFloat((UnitVariables)event), this.alignY);
        float az = this.z.getFloat((UnitVariables)event);
        boolean c = this.centered.getBoolean((UnitVariables)event);
        boolean s = this.shadow.getBoolean((UnitVariables)event);
        event.push();
        event.translate(ax, ay, az);
        event.scale(this.scale.getFloat((UnitVariables)event));
        for (int i = 0; i < this.text.length; ++i) {
            event.rawText(this.text[i], c ? -(this.textWidth[i] / 2.0f) : 0.0f, (float)i * ls, this.color.getInt((UnitVariables)event), s);
        }
        event.pop();
    }
}

