/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.fluid.BoundFluidStackJS;
import dev.latvian.mods.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.mods.kubejs.fluid.UnboundFluidStackJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public abstract class FluidStackJS
implements WrappedJS,
Copyable {
    private double chance = Double.NaN;

    public static FluidStackJS of(@Nullable Object o) {
        if (o == null) {
            return EmptyFluidStackJS.INSTANCE;
        }
        if (o instanceof FluidStackJS) {
            FluidStackJS js = (FluidStackJS)o;
            return js;
        }
        if (o instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)o;
            return new BoundFluidStackJS(fluidStack);
        }
        if (o instanceof class_3611) {
            class_3611 fluid = (class_3611)o;
            UnboundFluidStackJS f = new UnboundFluidStackJS(Registries.getId((Object)fluid, (class_5321)class_2378.field_25103));
            return f.isEmpty() ? EmptyFluidStackJS.INSTANCE : f;
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return FluidStackJS.fromJson(json);
        }
        if (o instanceof CharSequence || o instanceof class_2960) {
            String s = o.toString();
            if (s.isEmpty() || s.equals("-") || s.equals("empty") || s.equals("minecraft:empty")) {
                return EmptyFluidStackJS.INSTANCE;
            }
            String[] s1 = s.split(" ", 2);
            return new UnboundFluidStackJS(new class_2960(s1[0])).withAmount(UtilsJS.parseLong(s1.length == 2 ? s1[1] : "", FluidStack.bucketAmount()));
        }
        MapJS map = MapJS.of(o);
        if (map != null && map.containsKey("fluid")) {
            UnboundFluidStackJS stack = new UnboundFluidStackJS(new class_2960(map.get("fluid").toString()));
            Object v = map.get("amount");
            if (v instanceof Number) {
                Number num = (Number)v;
                ((FluidStackJS)stack).setAmount(num.longValue());
            }
            if (map.containsKey("nbt")) {
                ((FluidStackJS)stack).setNbt(NBTUtils.toTagCompound(map.get("nbt")));
            }
            return stack;
        }
        return EmptyFluidStackJS.INSTANCE;
    }

    public static FluidStackJS of(@Nullable Object o, long amount, @Nullable class_2487 nbt) {
        FluidStackJS stack = FluidStackJS.of(o);
        stack.setAmount(amount);
        stack.setNbt(nbt);
        return stack;
    }

    public static FluidStackJS fromJson(JsonElement e) {
        if (!e.isJsonObject()) {
            return FluidStackJS.of(e.getAsString());
        }
        JsonObject json = e.getAsJsonObject();
        FluidStackJS fluid = FluidStackJS.of(json.get("fluid").getAsString());
        if (fluid.isEmpty()) {
            throw new RecipeExceptionJS(json + " is not a valid fluid!");
        }
        long amount = FluidStack.bucketAmount();
        class_2487 nbt = null;
        if (json.has("amount")) {
            amount = json.get("amount").getAsInt();
        } else if (json.has("count")) {
            amount = json.get("count").getAsInt();
        }
        if (json.has("nbt")) {
            nbt = json.get("nbt").isJsonObject() ? NBTUtils.toTagCompound((Object)json.get("nbt")) : NBTUtils.toTagCompound((Object)json.get("nbt").getAsString());
        }
        return FluidStackJS.of(fluid, amount, nbt);
    }

    public abstract String getId();

    public Collection<class_2960> getTags() {
        return Tags.byFluid(this.getFluid()).map(class_6862::comp_327).collect(Collectors.toSet());
    }

    public boolean hasTag(class_2960 tag) {
        return this.getFluid().method_15791(Tags.fluid(tag));
    }

    public class_3611 getFluid() {
        class_3611 f = (class_3611)KubeJSRegistries.fluids().get(new class_2960(this.getId()));
        return f == null ? class_3612.field_15906 : f;
    }

    public abstract FluidStack getFluidStack();

    public boolean isEmpty() {
        return this.getAmount() <= 0L;
    }

    public abstract long getAmount();

    public abstract void setAmount(long var1);

    public final FluidStackJS withAmount(long amount) {
        if (amount <= 0L) {
            return EmptyFluidStackJS.INSTANCE;
        }
        FluidStackJS fs = this.copy();
        fs.setAmount(amount);
        return fs;
    }

    @Nullable
    public abstract class_2487 getNbt();

    public abstract void setNbt(@Nullable class_2487 var1);

    public final FluidStackJS withNBT(@Nullable class_2487 nbt) {
        FluidStackJS fs = this.copy();
        fs.setNbt(nbt);
        return fs;
    }

    public abstract FluidStackJS copy();

    public boolean hasChance() {
        return !Double.isNaN(this.chance);
    }

    public void removeChance() {
        this.setChance(Double.NaN);
    }

    public void setChance(double c) {
        this.chance = c;
    }

    public double getChance() {
        return this.chance;
    }

    public final FluidStackJS withChance(double c) {
        if (Double.isNaN(this.chance) && Double.isNaN(c) || this.chance == c) {
            return this;
        }
        FluidStackJS is = this.copy();
        is.setChance(c);
        return is;
    }

    public int hashCode() {
        return Objects.hash(this.getFluid(), this.getNbt());
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(o.toString());
        }
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public boolean strongEquals(Object o) {
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getAmount() == f.getAmount() && this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public String toString() {
        long amount = this.getAmount();
        class_2487 nbt = this.getNbt();
        StringBuilder builder = new StringBuilder();
        builder.append("Fluid.of('");
        builder.append(this.getId());
        if (amount != FluidStack.bucketAmount()) {
            builder.append(", ");
            builder.append(amount);
        }
        if (nbt != null) {
            builder.append(", ");
            NBTUtils.quoteAndEscapeForJS((StringBuilder)builder, (String)nbt.toString());
        }
        builder.append("')");
        if (this.hasChance()) {
            builder.append(".withChance(");
            builder.append(this.getChance());
            builder.append(')');
        }
        return builder.toString();
    }

    public JsonObject toJson() {
        JsonObject o = new JsonObject();
        o.addProperty("fluid", this.getId());
        o.addProperty("amount", (Number)this.getAmount());
        if (this.getNbt() != null) {
            o.add("nbt", (JsonElement)MapJS.json(this.getNbt()));
        }
        if (this.hasChance()) {
            o.addProperty("chance", (Number)this.getChance());
        }
        return o;
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        this.getFluidStack().write(tag);
        return tag;
    }
}

