/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.architectury.event.EventResult;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.integration.rei.AddREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.EntryWrapper;
import dev.latvian.mods.kubejs.integration.rei.HideREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.InformationREIEventJS;
import dev.latvian.mods.kubejs.integration.rei.KubeJSAddREIWrapperEvent;
import dev.latvian.mods.kubejs.integration.rei.REIGroupEntriesEventJS;
import dev.latvian.mods.kubejs.integration.rei.RemoveREICategoryEventJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1856;
import net.minecraft.class_2960;

public class KubeJSREIPlugin
implements REIClientPlugin {
    private final Set<CategoryIdentifier<?>> categoriesRemoved = new HashSet();
    private static final Map<EntryType<?>, EntryWrapper> entryWrappers = new HashMap();

    public KubeJSREIPlugin() {
        entryWrappers.clear();
        entryWrappers.put(VanillaEntryTypes.ITEM, o -> EntryIngredients.ofIngredient((class_1856)IngredientJS.of(o).createVanillaIngredient()));
        entryWrappers.put(VanillaEntryTypes.FLUID, o -> EntryIngredients.of((FluidStack)FluidStackJS.of(o).getFluidStack()));
        ((Consumer)KubeJSAddREIWrapperEvent.EVENT.invoker()).accept(entryWrappers::put);
    }

    public double getPriority() {
        return 1.0E7;
    }

    public void registerEntries(EntryRegistry registry) {
        entryWrappers.forEach((type, wrapper) -> {
            String typeId = UtilsJS.stripIdForEvent(type.getId());
            BasicFilteringRule filteringRule = FilteringRuleTypeRegistry.getInstance().basic();
            new AddREIEventJS(registry, (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.add.%s".formatted(typeId));
            if (type.getId().method_12836().equals("minecraft")) {
                String shortId = UtilsJS.stripEventName(type.getId().method_12832());
                new AddREIEventJS(registry, (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.add.%s".formatted(shortId));
            }
            if (type == VanillaEntryTypes.ITEM) {
                new AddREIEventJS(registry, (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.add.%s".formatted("items"));
            } else if (type == VanillaEntryTypes.FLUID) {
                new AddREIEventJS(registry, (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.add.%s".formatted("fluids"));
            }
        });
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        entryWrappers.forEach((type, wrapper) -> {
            String typeId = UtilsJS.stripIdForEvent(type.getId());
            EntryRegistry registry = EntryRegistry.getInstance();
            new HideREIEventJS(registry, rule, (EntryType)UtilsJS.cast(type), (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.hide.%s".formatted(typeId));
            if (type.getId().method_12836().equals("minecraft")) {
                String shortId = UtilsJS.stripEventName(type.getId().method_12832());
                new HideREIEventJS(registry, rule, (EntryType)UtilsJS.cast(type), (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.hide.%s".formatted(shortId));
            }
            if (type == VanillaEntryTypes.ITEM) {
                new HideREIEventJS(registry, rule, VanillaEntryTypes.ITEM, (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.hide.%s".formatted("items"));
            } else if (type == VanillaEntryTypes.FLUID) {
                new HideREIEventJS(registry, rule, VanillaEntryTypes.FLUID, (EntryWrapper)wrapper).post(ScriptType.CLIENT, "rei.hide.%s".formatted("fluids"));
            }
        });
    }

    public void registerDisplays(DisplayRegistry registry) {
        new InformationREIEventJS().post(ScriptType.CLIENT, "rei.information");
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.registerVisibilityPredicate(category -> this.categoriesRemoved.contains(category.getCategoryIdentifier()) ? EventResult.interruptFalse() : EventResult.pass());
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage == ReloadStage.END) {
            this.categoriesRemoved.clear();
            new RemoveREICategoryEventJS(this.categoriesRemoved).post(ScriptType.CLIENT, "rei.remove.categories");
        }
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        new REIGroupEntriesEventJS(registry).post(ScriptType.CLIENT, "rei.group");
    }

    public static EntryType<?> getTypeOrThrow(class_2960 typeId) {
        return Objects.requireNonNull(EntryTypeRegistry.getInstance().get(typeId), "Entry type '%s' not found!".formatted(typeId)).getType();
    }

    public static EntryWrapper getWrapperOrFallback(EntryType<?> type) {
        EntryWrapper wrapper = entryWrappers.get(type);
        if (wrapper != null) {
            return wrapper;
        }
        ConsoleJS.CLIENT.warn("No wrapper found for entry type '%s', trying to fall back to id-based wrapper!".formatted(type.getId()));
        return o -> {
            Set ids = CollectionUtils.mapToSet((Collection)ListJS.orSelf(o), UtilsJS::getMCID);
            return EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getType().equals(type)).filter(stack -> ids.contains(stack.getIdentifier())).toList();
        };
    }
}

