/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.architectury.hooks.item.food.FoodPropertiesHooks;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ItemFoodEatenEventJS;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5321;

public class FoodBuilder {
    private int hunger;
    private float saturation;
    private boolean meat;
    private boolean alwaysEdible;
    private boolean fastToEat;
    private final List<org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float>> effects = Lists.newArrayList();
    public Consumer<ItemFoodEatenEventJS> eaten;

    public FoodBuilder() {
    }

    public FoodBuilder(class_4174 properties) {
        this.hunger = properties.method_19230();
        this.saturation = properties.method_19231();
        this.meat = properties.method_19232();
        this.alwaysEdible = properties.method_19233();
        this.fastToEat = properties.method_19234();
        properties.method_19235().forEach(pair -> this.effects.add((org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float>)org.apache.commons.lang3.tuple.Pair.of(() -> ((Pair)pair).getFirst(), (Object)((Float)pair.getSecond()))));
    }

    public FoodBuilder hunger(int h) {
        this.hunger = h;
        return this;
    }

    public FoodBuilder saturation(float s) {
        this.saturation = s;
        return this;
    }

    public FoodBuilder meat(boolean flag) {
        this.meat = flag;
        return this;
    }

    public FoodBuilder meat() {
        return this.meat(true);
    }

    public FoodBuilder alwaysEdible(boolean flag) {
        this.alwaysEdible = flag;
        return this;
    }

    public FoodBuilder alwaysEdible() {
        return this.alwaysEdible(true);
    }

    public FoodBuilder fastToEat(boolean flag) {
        this.fastToEat = flag;
        return this;
    }

    public FoodBuilder fastToEat() {
        return this.fastToEat(true);
    }

    public FoodBuilder effect(class_2960 mobEffectId, int duration, int amplifier, float probability) {
        this.effects.add((org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float>)org.apache.commons.lang3.tuple.Pair.of((Object)new EffectSupplier(mobEffectId, duration, amplifier), (Object)Float.valueOf(probability)));
        return this;
    }

    public FoodBuilder removeEffect(class_1291 mobEffect) {
        if (mobEffect == null) {
            return this;
        }
        this.effects.removeIf(pair -> {
            class_1293 effectInstance = (class_1293)((Supplier)pair.getKey()).get();
            return effectInstance.method_5586().equals(mobEffect.method_5567());
        });
        return this;
    }

    public FoodBuilder eaten(Consumer<ItemFoodEatenEventJS> e) {
        this.eaten = e;
        return this;
    }

    public class_4174 build() {
        class_4174.class_4175 b = new class_4174.class_4175();
        b.method_19238(this.hunger);
        b.method_19237(this.saturation);
        if (this.meat) {
            b.method_19236();
        }
        if (this.alwaysEdible) {
            b.method_19240();
        }
        if (this.fastToEat) {
            b.method_19241();
        }
        for (org.apache.commons.lang3.tuple.Pair<Supplier<class_1293>, Float> effect : this.effects) {
            FoodPropertiesHooks.effect((class_4174.class_4175)b, (Supplier)((Supplier)effect.getLeft()), (float)((Float)effect.getRight()).floatValue());
        }
        return b.method_19242();
    }

    private static class EffectSupplier
    implements Supplier<class_1293> {
        private final class_2960 id;
        private final int duration;
        private final int amplifier;
        private class_1291 cachedEffect;

        public EffectSupplier(class_2960 id, int duration, int amplifier) {
            this.id = id;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public class_1293 get() {
            if (this.cachedEffect == null) {
                this.cachedEffect = (class_1291)KubeJSRegistries.mobEffects().get(this.id);
                if (this.cachedEffect == null) {
                    Set effectIds = KubeJSRegistries.mobEffects().entrySet().stream().map(entry -> ((class_5321)entry.getKey()).method_29177()).collect(Collectors.toSet());
                    throw new RuntimeException(String.format("Missing effect '%s'. Check spelling or maybe potion id was used instead of effect id. Possible ids: %s", this.id, effectIds));
                }
            }
            return new class_1293(this.cachedEffect, this.duration, this.amplifier);
        }
    }
}

