/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public final class WeakNBTIngredientJS
implements IngredientJS {
    private final ItemStackJS item;

    public WeakNBTIngredientJS(ItemStackJS i) {
        this.item = i;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        if (this.item.areItemsEqual(stack) && this.item.hasNBT() == stack.hasNBT()) {
            if (this.item.hasNBT()) {
                for (String key : this.item.getNbt().method_10541()) {
                    if (Objects.equals(this.item.getNbt().method_10580(key), stack.getNbt().method_10580(key))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanilla(class_1799 stack) {
        if (this.item.areItemsEqual(stack) && this.item.hasNBT() == stack.method_7985()) {
            if (this.item.hasNBT()) {
                class_2487 t = this.item.getNbt();
                for (String key : t.method_10541()) {
                    if (Objects.equals(t.method_10580(key), stack.method_7969().method_10580(key))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanillaItem(class_1792 i) {
        return this.item.getItem() == i;
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return this.item.getStacks();
    }

    @Override
    public Set<class_1792> getVanillaItems() {
        return Collections.singleton(this.item.getItem());
    }

    @Override
    public IngredientJS copy() {
        return new WeakNBTIngredientJS(this.item.copy());
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.item.getId());
        if (this.item.hasNBT()) {
            json.addProperty("type", "forge:partial_nbt");
            json.addProperty("nbt", this.item.getNbtString());
        }
        return json;
    }

    public String toString() {
        String stack = this.item.toString().replaceAll("^'(.*)'$", "Item.of($1)");
        return stack + ".weakNBT()";
    }
}

