/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.util.UUIDTypeAdapter;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.DamageAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.mods.kubejs.recipe.ingredientaction.KeepAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.ReplaceAction;
import dev.latvian.mods.kubejs.recipe.minecraft.CustomRecipeJS;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeJS {
    public static RecipeJS currentRecipe = null;
    public static boolean itemErrors = false;
    public class_2960 id;
    public RecipeTypeJS type;
    public JsonObject originalJson = null;
    public JsonObject json = null;
    public class_1860<?> originalRecipe = null;
    public final List<ItemStackJS> outputItems = new ArrayList<ItemStackJS>(1);
    public final List<IngredientJS> inputItems = new ArrayList<IngredientJS>(1);
    public boolean serializeOutputs;
    public boolean serializeInputs;
    private String recipeStage = "";

    public abstract void create(ListJS var1);

    public abstract void deserialize();

    public abstract void serialize();

    public final void deserializeJson() {
        currentRecipe = this;
        this.deserialize();
        if (CommonProperties.get().debugInfo) {
            this.originalJson = (JsonObject)JsonIO.copy((JsonElement)this.json);
        }
        currentRecipe = null;
    }

    public final void serializeJson() {
        currentRecipe = this;
        this.json.addProperty("type", this.type.getId().toString());
        this.serialize();
        currentRecipe = null;
    }

    public final void save() {
        this.originalRecipe = null;
    }

    public RecipeJS merge(Object data) {
        JsonObject j = MapJS.json(data);
        if (j != null) {
            for (Map.Entry entry : j.entrySet()) {
                this.json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            this.save();
        }
        return this;
    }

    public RecipeJS id(class_2960 _id) {
        this.id = _id;
        this.save();
        return this;
    }

    public RecipeJS group(String g) {
        this.setGroup(g);
        this.save();
        return this;
    }

    public final boolean hasInput(IngredientJS ingredient, boolean exact) {
        if (this.getInputIndex(ingredient, exact) != -1) {
            return true;
        }
        if (this.originalRecipe != null && this instanceof CustomRecipeJS && ServerSettings.instance.useOriginalRecipeForFilters) {
            try {
                for (class_1856 in0 : this.originalRecipe.method_8117()) {
                    IngredientJS in = IngredientJS.of(in0);
                    if (in.isEmpty() || !(exact ? in.equals(ingredient) : in.anyStackMatches(ingredient))) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final int getInputIndex(IngredientJS ingredient, boolean exact) {
        for (int i = 0; i < this.inputItems.size(); ++i) {
            IngredientJS in = this.inputItems.get(i);
            if (!(exact ? in.equals(ingredient) : in.anyStackMatches(ingredient))) continue;
            return i;
        }
        return -1;
    }

    public final boolean replaceInput(IngredientJS i, IngredientJS with, boolean exact) {
        return this.replaceInput(i, with, exact, (in, original) -> in.withCount(original.getCount()));
    }

    public final boolean replaceInput(IngredientJS i, IngredientJS with, boolean exact, BiFunction<IngredientJS, IngredientJS, IngredientJS> func) {
        boolean changed = false;
        for (int j = 0; j < this.inputItems.size(); ++j) {
            if (!(exact ? this.inputItems.get(j).equals(i) : this.inputItems.get(j).anyStackMatches(i))) continue;
            this.inputItems.set(j, this.convertReplacedInput(j, this.inputItems.get(j), func.apply(with.copy(), this.inputItems.get(j))));
            changed = true;
            this.serializeInputs = true;
            this.save();
        }
        return changed;
    }

    public final boolean hasOutput(IngredientJS ingredient, boolean exact) {
        if (this.getOutputIndex(ingredient, exact) != -1) {
            return true;
        }
        if (this.originalRecipe != null && this instanceof CustomRecipeJS && ServerSettings.instance.useOriginalRecipeForFilters) {
            try {
                ItemStackJS out = ItemStackJS.of(this.originalRecipe.method_8110());
                if (!out.isEmpty()) {
                    return exact ? ingredient.equals(out) : ingredient.test(out);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final int getOutputIndex(IngredientJS ingredient, boolean exact) {
        for (int i = 0; i < this.outputItems.size(); ++i) {
            ItemStackJS out = this.outputItems.get(i);
            if (!(exact ? ingredient.equals(out) : ingredient.test(out))) continue;
            return i;
        }
        return -1;
    }

    public final boolean replaceOutput(IngredientJS i, ItemStackJS with, boolean exact) {
        return this.replaceOutput(i, with, exact, (out, original) -> out.withCount(original.getCount()).withChance(original.getChance()));
    }

    public final boolean replaceOutput(IngredientJS i, ItemStackJS with, boolean exact, BiFunction<ItemStackJS, ItemStackJS, ItemStackJS> func) {
        boolean changed = false;
        for (int j = 0; j < this.outputItems.size(); ++j) {
            if (!(exact ? i.equals(this.outputItems.get(j)) : i.test(this.outputItems.get(j)))) continue;
            this.outputItems.set(j, this.convertReplacedOutput(j, this.outputItems.get(j), func.apply(with.copy(), this.outputItems.get(j))));
            changed = true;
            this.serializeOutputs = true;
            this.save();
        }
        return changed;
    }

    public String getGroup() {
        JsonElement e = this.json.get("group");
        return e instanceof JsonPrimitive ? e.getAsString() : "";
    }

    public void setGroup(String g) {
        if (g.isEmpty()) {
            this.json.remove("group");
        } else {
            this.json.addProperty("group", g);
        }
        this.save();
    }

    public String toString() {
        return this.getOrCreateId() + "[" + this.type + "]";
    }

    public String getId() {
        return this.getOrCreateId().toString();
    }

    public String getMod() {
        return this.getOrCreateId().method_12836();
    }

    public String getPath() {
        return this.getOrCreateId().method_12832();
    }

    public String getType() {
        return this.type.toString();
    }

    public class_2960 getOrCreateId() {
        if (this.id == null) {
            this.id = new class_2960(this.type.getId().method_12836() + ":kjs_" + this.getUniqueId());
        }
        return this.id;
    }

    public IngredientJS convertReplacedInput(int index, IngredientJS oldIngredient, IngredientJS newIngredient) {
        return newIngredient;
    }

    public ItemStackJS convertReplacedOutput(int index, ItemStackJS oldStack, ItemStackJS newStack) {
        return newStack;
    }

    @Nullable
    public ItemStackJS resultFromRecipeJson(JsonObject json) {
        return null;
    }

    @Nullable
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        return null;
    }

    @Nullable
    public JsonElement serializeItemStack(ItemStackJS stack) {
        return null;
    }

    public IngredientJS parseIngredientItem(@Nullable Object o, String key) {
        IngredientJS ingredient = IngredientJS.of(o);
        if (ingredient.isInvalidRecipeIngredient() && !Platform.isFabric()) {
            if (key.isEmpty()) {
                throw new RecipeExceptionJS(o + " is not a valid ingredient!");
            }
            throw new RecipeExceptionJS(o + " with key '" + key + "' is not a valid ingredient!");
        }
        return ingredient;
    }

    public IngredientJS parseIngredientItem(@Nullable Object o) {
        return this.parseIngredientItem(o, "");
    }

    public ItemStackJS parseResultItem(@Nullable Object o) {
        ItemStackJS result = ItemStackJS.of(o);
        if (result.isInvalidRecipeIngredient() && !Platform.isFabric()) {
            throw new RecipeExceptionJS(o + " is not a valid result!");
        }
        return result;
    }

    public List<IngredientJS> parseIngredientItemList(@Nullable Object o) {
        ArrayList<IngredientJS> list = new ArrayList<IngredientJS>();
        if (o instanceof JsonElement) {
            JsonArray jsonArray;
            JsonElement elem = (JsonElement)o;
            if (elem instanceof JsonArray) {
                JsonArray arr2 = (JsonArray)elem;
                jsonArray = arr2;
            } else {
                jsonArray = (JsonArray)class_156.method_654((Object)new JsonArray(), arr -> arr.add(elem));
            }
            JsonArray array = jsonArray;
            for (JsonElement e : array) {
                list.add(this.parseIngredientItem(e));
            }
        } else {
            for (Object o1 : ListJS.orSelf(o)) {
                list.add(this.parseIngredientItem(o1));
            }
        }
        return list;
    }

    public List<IngredientStackJS> parseIngredientItemStackList(@Nullable Object o) {
        return this.parseIngredientItemList(o).stream().map(IngredientJS::asIngredientStack).collect(Collectors.toList());
    }

    public List<ItemStackJS> parseResultItemList(@Nullable Object o) {
        ArrayList<ItemStackJS> list = new ArrayList<ItemStackJS>();
        if (o instanceof JsonElement) {
            JsonArray jsonArray;
            JsonElement elem = (JsonElement)o;
            if (elem instanceof JsonArray) {
                JsonArray arr2 = (JsonArray)elem;
                jsonArray = arr2;
            } else {
                jsonArray = (JsonArray)class_156.method_654((Object)new JsonArray(), arr -> arr.add(elem));
            }
            JsonArray array = jsonArray;
            for (JsonElement e : array) {
                list.add(this.parseResultItem(e));
            }
        } else {
            for (Object o1 : ListJS.orSelf(o)) {
                list.add(this.parseResultItem(o1));
            }
        }
        return list;
    }

    public String getFromToString() {
        return this.inputItems + " -> " + this.outputItems;
    }

    public String getUniqueId() {
        return UtilsJS.getUniqueId((JsonElement)this.json);
    }

    public RecipeJS stage(String s) {
        this.recipeStage = s;
        this.save();
        if (!Platform.isModLoaded((String)"recipestages")) {
            ConsoleJS.SERVER.warn("Recipe requires stage '" + this.recipeStage + "' but Recipe Stages mod isn't installed!");
        }
        return this;
    }

    public class_1860<?> createRecipe() throws Throwable {
        this.serializeJson();
        if (!this.recipeStage.isEmpty() && Platform.isModLoaded((String)"recipestages")) {
            class_1865 stageSerializer = (class_1865)KubeJSRegistries.recipeSerializers().get(new class_2960("recipestages:stage"));
            JsonObject o = new JsonObject();
            o.addProperty("stage", this.recipeStage);
            o.add("recipe", (JsonElement)this.json);
            return stageSerializer.method_8121(this.getOrCreateId(), o);
        }
        return Objects.requireNonNull(RecipePlatformHelper.get().fromJson(this));
    }

    public ItemStackJS getOriginalRecipeResult() {
        if (this.originalRecipe == null) {
            ConsoleJS.SERVER.warn("Original recipe is null - could not get result");
            return ItemStackJS.EMPTY;
        }
        return ItemStackJS.of(this.originalRecipe.method_8110());
    }

    public List<IngredientJS> getOriginalRecipeIngredients() {
        if (this.originalRecipe == null) {
            ConsoleJS.SERVER.warn("Original recipe is null - could not get ingredients");
            return new ArrayList<IngredientJS>();
        }
        return this.originalRecipe.method_8117().stream().map(IngredientJS::of).collect(Collectors.toList());
    }

    public void dontAdd() {
        RecipeEventJS.instance.addedRecipes.remove(this);
    }

    public boolean serializeNBTAsJson() {
        return this.type != null && this.type.getMod().equals("techreborn");
    }

    public RecipeJS ingredientAction(IngredientActionFilter filter, IngredientAction action) {
        JsonArray arr2;
        JsonElement jsonElement = this.json.get("kubejs_actions");
        JsonArray array = jsonElement instanceof JsonArray ? (arr2 = (JsonArray)jsonElement) : (JsonArray)class_156.method_654((Object)new JsonArray(), arr -> this.json.add("kubejs_actions", (JsonElement)arr));
        action.copyFrom(filter);
        array.add((JsonElement)action.toJson());
        this.save();
        return this;
    }

    public final RecipeJS damageIngredient(IngredientActionFilter filter, int damage) {
        return this.ingredientAction(filter, new DamageAction(damage));
    }

    public final RecipeJS damageIngredient(IngredientActionFilter filter) {
        return this.damageIngredient(filter, 1);
    }

    public final RecipeJS replaceIngredient(IngredientActionFilter filter, ItemStackJS item) {
        return this.ingredientAction(filter, new ReplaceAction(item.getItemStack()));
    }

    public final RecipeJS customIngredientAction(IngredientActionFilter filter, String id) {
        return this.ingredientAction(filter, new CustomIngredientAction(id));
    }

    public final RecipeJS keepIngredient(IngredientActionFilter filter) {
        return this.ingredientAction(filter, new KeepAction());
    }

    public final RecipeJS modifyResult(ModifyRecipeResultCallback callback) {
        UUID id = UUID.randomUUID();
        RecipeEventJS.modifyResultCallbackMap.put(id, callback);
        this.json.addProperty("kubejs_modify_result", UUIDTypeAdapter.fromUUID((UUID)id));
        this.save();
        return this;
    }
}

