/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.architectury.registry.registries.Registries;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.recipe.IgnoredRecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.ShapedRecipeJS;
import dev.latvian.mods.kubejs.recipe.minecraft.ShapelessRecipeJS;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public record RegisterRecipeHandlersEvent(Map<class_2960, RecipeTypeJS> map) {
    public void register(RecipeTypeJS type) {
        this.map.put(Registries.getId(type.serializer, (class_5321)class_2378.field_25085), type);
        KubeJS.LOGGER.info("Registered custom recipe handler for type " + type);
    }

    public void register(class_2960 id, Supplier<RecipeJS> f) {
        block2: {
            try {
                this.register(new RecipeTypeJS(Objects.requireNonNull((class_1865)KubeJSRegistries.recipeSerializers().get(id)), f));
            }
            catch (NullPointerException e) {
                if (!ServerSettings.instance.logErroringRecipes) break block2;
                ConsoleJS.SERVER.warn("Failed to register handler for recipe type " + id + " as it doesn't exist!");
            }
        }
    }

    public void register(String id, Supplier<RecipeJS> f) {
        this.register(new class_2960(id), f);
    }

    public void ignore(class_2960 id) {
        block2: {
            try {
                this.register(new IgnoredRecipeTypeJS(Objects.requireNonNull((class_1865)KubeJSRegistries.recipeSerializers().get(id))));
            }
            catch (NullPointerException e) {
                if (!ServerSettings.instance.logErroringRecipes) break block2;
                ConsoleJS.SERVER.warn("Failed to ignore recipe type " + id + " as it doesn't exist!");
            }
        }
    }

    public void ignore(String id) {
        this.ignore(new class_2960(id));
    }

    public void registerShaped(class_2960 id) {
        this.register(id, ShapedRecipeJS::new);
    }

    public void registerShapeless(class_2960 id) {
        this.register(id, ShapelessRecipeJS::new);
    }

    private void handleMissingSerializer(class_2960 id) {
        if (ServerSettings.instance.logInvalidRecipeHandlers) {
            throw new NullPointerException("Cannot find recipe serializer: " + id);
        }
        if (ServerSettings.instance.logErroringRecipes) {
            KubeJS.LOGGER.warn("Skipping recipe handler for serializer " + id + " as it does not exist!");
        }
    }
}

