/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.core.TagBuilderKJS;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class TagEventJS<T>
extends EventJS {
    private final String type;
    private final Map<class_2960, class_3494.class_3495> map;
    private final class_2378<T> registry;
    private Map<class_2960, TagWrapper> tags;
    private int totalAdded;
    private int totalRemoved;
    private List<Predicate<class_2960>> globalPriorityList;

    private static String getIdOfEntry(class_3494.class_3496 entry) {
        JsonElement asJson = ((JsonArray)class_156.method_654((Object)new JsonArray(), arg_0 -> ((class_3494.class_3496)entry).method_26789(arg_0))).get(0);
        if (asJson instanceof JsonObject) {
            JsonObject obj = (JsonObject)asJson;
            return obj.get("id").getAsString();
        }
        return asJson.getAsString();
    }

    @Nullable
    private static List<Predicate<class_2960>> parsePriorityList(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Predicate<class_2960>> list = new ArrayList<Predicate<class_2960>>();
        for (Object o1 : ListJS.orSelf(o)) {
            String m;
            String s = String.valueOf(o1);
            if (s.startsWith("@")) {
                m = s.substring(1);
                list.add(id -> id.method_12836().equals(m));
                continue;
            }
            if (s.startsWith("!@")) {
                m = s.substring(2);
                list.add(id -> !id.method_12836().equals(m));
                continue;
            }
            list.add(id -> id.equals((Object)UtilsJS.getMCID(s)));
        }
        return list.isEmpty() ? null : list;
    }

    public TagEventJS(String t, Map<class_2960, class_3494.class_3495> m, class_2378<T> r) {
        this.type = t;
        this.map = m;
        this.registry = r;
        this.totalAdded = 0;
        this.totalRemoved = 0;
        this.globalPriorityList = null;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void post(String event) {
        Path dumpFile = KubeJSPaths.EXPORTED.resolve("tags/" + this.type + ".txt");
        if (!Files.exists(dumpFile, new LinkOption[0])) {
            try {
                if (!Files.exists(dumpFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dumpFile.getParent(), new FileAttribute[0]);
                }
                ArrayList<CallSite> lines = new ArrayList<CallSite>();
                this.map.forEach((tagId, tagBuilder) -> {
                    lines.add((CallSite)((Object)""));
                    lines.add((CallSite)((Object)("#" + tagId)));
                    tagBuilder.method_26785().forEach(builderEntry -> lines.add((CallSite)((Object)("- " + builderEntry.comp_324()))));
                });
                lines.add(0, (CallSite)((Object)("To refresh this file, delete it and run /reload command again! Last updated: " + DateFormat.getDateTimeInstance().format(new Date()))));
                Files.write(dumpFile, lines, new OpenOption[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.tags = new HashMap<class_2960, TagWrapper>();
        for (Map.Entry<class_2960, class_3494.class_3495> entry : this.map.entrySet()) {
            TagWrapper tagWrapper = new TagWrapper(entry.getKey(), entry.getValue());
            this.tags.put(entry.getKey(), tagWrapper);
            ConsoleJS.SERVER.debug("%s/#%s; %d".formatted(this.type, entry.getKey(), tagWrapper.proxyList.size()));
        }
        RegistryObjectBuilderTypes<?> types = RegistryObjectBuilderTypes.MAP.get(this.registry.method_30517());
        if (types != null) {
            for (BuilderBase builderBase : types.objects.values()) {
                for (class_2960 s : builderBase.defaultTags) {
                    this.add(s, builderBase.id.toString());
                }
            }
        }
        ConsoleJS.SERVER.setLineNumber(true);
        this.post(ScriptType.SERVER, event);
        ConsoleJS.SERVER.setLineNumber(false);
        boolean bl = false;
        for (TagWrapper wrapper : this.tags.values()) {
            void var4_9;
            if (wrapper.priorityList == null) {
                wrapper.priorityList = this.globalPriorityList;
            }
            if (wrapper.priorityList == null || !wrapper.sort()) continue;
            ++var4_9;
        }
        if (ServerSettings.dataExport != null && this.registry != null) {
            void var5_16;
            JsonObject tj1;
            JsonObject jsonObject = ServerSettings.dataExport.getAsJsonObject("tags");
            if (jsonObject == null) {
                JsonObject jsonObject2 = new JsonObject();
                ServerSettings.dataExport.add("tags", (JsonElement)jsonObject2);
            }
            if ((tj1 = var5_16.getAsJsonObject(this.type)) == null) {
                tj1 = new JsonObject();
                var5_16.add(this.type, (JsonElement)tj1);
            }
            for (Map.Entry<class_2960, class_3494.class_3495> entry : this.map.entrySet()) {
                JsonArray a = new JsonArray();
                entry.getValue().method_26785().forEach(e -> a.add(e.comp_324().toString()));
                tj1.add(entry.getKey().toString(), (JsonElement)a);
            }
        }
        if (this.totalAdded > 0 || this.totalRemoved > 0 || ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.info("[" + this.type + "] Found " + this.tags.size() + " tags, added " + this.totalAdded + " objects, removed " + this.totalRemoved + " objects");
        }
    }

    public TagWrapper get(class_2960 id) {
        TagWrapper t = this.tags.get(id);
        if (t == null) {
            t = new TagWrapper(id, class_3494.class_3495.method_26778());
            this.tags.put(id, t);
            this.map.put(id, t.builder);
        }
        return t;
    }

    public TagWrapper add(class_2960 tag, String ... ids) {
        return this.get(tag).add(ids);
    }

    public TagWrapper remove(class_2960 tag, String ... ids) {
        return this.get(tag).remove(ids);
    }

    public TagWrapper removeAll(class_2960 tag) {
        return this.get(tag).removeAll();
    }

    public void removeAllTagsFrom(String ... ids) {
        for (String id : ids) {
            for (TagWrapper tagWrapper : this.tags.values()) {
                tagWrapper.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.comp_324()).equals(id));
            }
        }
    }

    public void setGlobalPriorityList(@Nullable Object o) {
        this.globalPriorityList = TagEventJS.parsePriorityList(o);
    }

    private Either<TagWrapper, List<class_6880.class_6883<T>>> gatherTargets(String target) {
        if (target.isEmpty()) {
            return Either.right(List.of());
        }
        String suffix = target.substring(1);
        return switch (target.charAt(0)) {
            case '#' -> Either.left((Object)this.get(new class_2960(suffix)));
            case '@' -> Either.right(this.ofKeySet(id -> id.method_29177().method_12836().equals(suffix)));
            case '/' -> Either.right(this.ofKeySet(id -> UtilsJS.parseRegex(target).matcher(id.method_29177().toString()).find()));
            default -> {
                class_5321 id = class_5321.method_29179((class_5321)this.registry.method_30517(), (class_2960)new class_2960(target));
                yield (Either)UtilsJS.cast(Either.right(List.of(this.registry.method_40290(id))));
            }
        };
    }

    private List<class_6880.class_6883<T>> ofKeySet(Predicate<class_5321<T>> predicate) {
        return this.registry.method_40270().filter(ref -> ref.method_40224(predicate)).toList();
    }

    public class TagWrapper {
        private final class_2960 id;
        private final class_3494.class_3495 builder;
        private final List<class_3494.class_5145> proxyList;
        private List<Predicate<class_2960>> priorityList;

        private TagWrapper(class_2960 i, class_3494.class_3495 t) {
            this.id = i;
            this.builder = t;
            this.proxyList = ((TagBuilderKJS)this.builder).getProxyListKJS();
            this.priorityList = null;
        }

        public String toString() {
            return "<%s / %s>".formatted(TagEventJS.this.type, this.id);
        }

        public TagWrapper add(String ... ids) {
            for (String stringId : ids) {
                TagEventJS.this.gatherTargets(stringId).ifLeft(wrapper -> {
                    this.builder.method_26787(wrapper.id, "kubejs");
                    TagEventJS.this.totalAdded += wrapper.proxyList.size();
                    if (ConsoleJS.SERVER.shouldPrintDebug()) {
                        ConsoleJS.SERVER.debug("+ %s // #%s".formatted(this, wrapper.id));
                    }
                }).ifRight(matches -> {
                    if (matches.isEmpty()) {
                        if (ServerSettings.instance.logSkippedRecipes) {
                            ConsoleJS.SERVER.warn("+ %s // %s [No matches found!]".formatted(this, stringId));
                        }
                        return;
                    }
                    TagEventJS.this.totalAdded += matches.size();
                    for (class_6880.class_6883 holder : matches) {
                        class_2960 id = holder.method_40237().method_29177();
                        this.builder.method_26784(id, "kubejs");
                        if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                        if (id.toString().equals(stringId)) {
                            ConsoleJS.SERVER.debug("+ %s // %s".formatted(this, id));
                            continue;
                        }
                        ConsoleJS.SERVER.debug("+ %s // %s (via %s)".formatted(this, id, stringId));
                    }
                });
            }
            return this;
        }

        public TagWrapper remove(String ... ids) {
            for (String stringId : ids) {
                TagEventJS.this.gatherTargets(stringId).ifLeft(wrapper -> {
                    String entryId = wrapper.id.toString();
                    int originalSize = this.proxyList.size();
                    this.proxyList.removeIf(proxy -> {
                        String proxyId = TagEventJS.getIdOfEntry(proxy.comp_324());
                        if (proxyId.startsWith("#")) {
                            return proxyId.substring(1).equals(entryId);
                        }
                        return false;
                    });
                    int removedCount = originalSize - this.proxyList.size();
                    if (removedCount == 0) {
                        if (ServerSettings.instance.logSkippedRecipes) {
                            ConsoleJS.SERVER.warn("- %s // #%s [No matches found!]".formatted(this, entryId));
                        }
                    } else {
                        TagEventJS.this.totalRemoved += removedCount;
                        if (ConsoleJS.SERVER.shouldPrintDebug()) {
                            ConsoleJS.SERVER.debug("- " + this + " // " + entryId);
                        }
                    }
                }).ifRight(matches -> {
                    int originalSize = this.proxyList.size();
                    block0: for (class_6880.class_6883 holder : matches) {
                        class_2960 id = holder.method_40237().method_29177();
                        ListIterator<class_3494.class_5145> iterator = this.proxyList.listIterator();
                        while (iterator.hasNext()) {
                            class_3494.class_5145 proxy = iterator.next();
                            if (!TagEventJS.getIdOfEntry(proxy.comp_324()).equals(id.toString())) continue;
                            iterator.remove();
                            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue block0;
                            if (id.toString().equals(stringId)) {
                                ConsoleJS.SERVER.debug("- %s // %s".formatted(this, id));
                                continue block0;
                            }
                            ConsoleJS.SERVER.debug("- %s // %s (via %s)".formatted(this, id, stringId));
                            continue block0;
                        }
                    }
                    int removedCount = originalSize - this.proxyList.size();
                    if (removedCount == 0) {
                        if (ServerSettings.instance.logSkippedRecipes) {
                            ConsoleJS.SERVER.warn("- %s // %s [No matches found!]".formatted(this, stringId));
                        }
                    } else {
                        TagEventJS.this.totalRemoved += removedCount;
                    }
                });
            }
            return this;
        }

        public TagWrapper removeAll() {
            if (ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.debug("- " + this + " // (all)");
            }
            if (!this.proxyList.isEmpty()) {
                TagEventJS.this.totalRemoved += this.proxyList.size();
                this.proxyList.clear();
            } else if (ServerSettings.instance.logSkippedRecipes) {
                ConsoleJS.SERVER.warn("Tag " + this + " didn't contain any elements, skipped");
            }
            return this;
        }

        public Collection<class_2960> getObjectIds() {
            LinkedHashSet<class_2960> set = new LinkedHashSet<class_2960>();
            for (class_3494.class_5145 proxy : this.proxyList) {
                this.gatherIdsFor(set, proxy.comp_324());
            }
            return set;
        }

        private void gatherIdsFor(Collection<class_2960> collection, class_3494.class_3496 entry) {
            String id = TagEventJS.getIdOfEntry(entry);
            if (id.startsWith("#")) {
                TagWrapper w = TagEventJS.this.tags.get(new class_2960(id.substring(1)));
                if (w != null && w != this) {
                    for (class_3494.class_5145 proxy : w.proxyList) {
                        this.gatherIdsFor(collection, proxy.comp_324());
                    }
                }
            } else {
                class_2960 entryId = new class_2960(id);
                if (TagEventJS.this.registry.method_10250(entryId)) {
                    collection.add(entryId);
                }
            }
        }

        public void setPriorityList(@Nullable Object o) {
            this.priorityList = TagEventJS.parsePriorityList(o);
        }

        public boolean sort() {
            ArrayList listOfLists = new ArrayList();
            for (int i = 0; i < this.priorityList.size() + 1; ++i) {
                listOfLists.add(new ArrayList());
            }
            for (class_3494.class_5145 proxy : this.proxyList) {
                boolean bl = false;
                HashSet<class_2960> set = new HashSet<class_2960>();
                this.gatherIdsFor(set, proxy.comp_324());
                block2: for (class_2960 id : set) {
                    for (int i = 0; i < this.priorityList.size(); ++i) {
                        if (!this.priorityList.get(i).test(id)) continue;
                        ((List)listOfLists.get(i)).add(proxy);
                        bl = true;
                        continue block2;
                    }
                }
                if (bl) continue;
                ((List)listOfLists.get(this.priorityList.size())).add(proxy);
            }
            ArrayList<class_3494.class_5145> proxyList0 = new ArrayList<class_3494.class_5145>(this.proxyList);
            this.proxyList.clear();
            for (List list : listOfLists) {
                this.proxyList.addAll(list);
            }
            if (!proxyList0.equals(this.proxyList)) {
                if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("* Re-arranged " + this);
                }
                return true;
            }
            return false;
        }
    }
}

